/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.common;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;

public class StringTool {
    private static final ObjectMapper om = new ObjectMapper();
    public static final String BLANK_STRING = "";
    private static final Log log = LogFactory.getLog(StringTool.class);

    public static long parseByteSize(String sizeStr, long defaultSize) {
        long size = defaultSize;
        if (StringUtils.isNotBlank((CharSequence)sizeStr)) {
            sizeStr = sizeStr.toUpperCase();
            long multiplex = 1L;
            if (sizeStr.endsWith("M")) {
                multiplex = 0x100000L;
                sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
            } else if (sizeStr.endsWith("G")) {
                multiplex = 0x40000000L;
                sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
            } else if (sizeStr.endsWith("T")) {
                multiplex = 0x10000000000L;
                sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
            } else if (sizeStr.endsWith("K")) {
                multiplex = 1024L;
                sizeStr = sizeStr.substring(0, sizeStr.length() - 1);
            }
            try {
                size = Long.parseLong(sizeStr) * multiplex;
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("failed to parse [%s] as byte size, using default value [%s]instead.", sizeStr, defaultSize), (Throwable)e);
            }
        }
        return size;
    }

    public static String toJson(Object obj) throws NuxeoException {
        try {
            return om.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            log.warn((Object)String.format("failed to convert object %s to json, return null.", obj), (Throwable)e);
            return null;
        }
    }

    public static String stringifyObject(Object obj) {
        if (obj == null) {
            return BLANK_STRING;
        }
        return obj.toString();
    }
}

