/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.source;

import com.iss.nuxeo.bulkimport.ImportContext;
import com.iss.nuxeo.bulkimport.source.FileSourceManager;
import com.iss.nuxeo.bulkimport.source.FileSourceProvider;
import com.iss.nuxeo.bulkimport.source.FileSourceProviderDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;

public class FileSourceManagerComponent
extends DefaultComponent
implements FileSourceManager {
    protected Map<String, FileSourceProvider> providers = new HashMap<String, FileSourceProvider>();
    protected static final String XP = "configuration";

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        this.providers.clear();
    }

    @Override
    public FileSourceProvider getFileSourceProvider(String id) {
        FileSourceProvider provider = this.providers.get(id);
        if (provider != null) {
            return provider;
        }
        FileSourceProviderDescriptor desc = (FileSourceProviderDescriptor)this.getDescriptor(XP, id);
        if (desc != null) {
            provider = this.createProvider(desc);
        }
        return provider;
    }

    @Override
    public FileSourceProvider getFileSourceProvider(ImportContext context) {
        return this.getFileSourceProvider("default");
    }

    protected FileSourceProvider createProvider(FileSourceProviderDescriptor desc) {
        FileSourceProvider provider;
        Class<?> klass = desc.getProviderClass();
        Map<String, String> properties = desc.getProperties();
        try {
            if (!FileSourceProvider.class.isAssignableFrom(klass)) {
                throw new RuntimeException("Unknown class for file source provider: " + klass);
            }
            Class<?> providerClass = klass;
            provider = (FileSourceProvider)providerClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
        try {
            provider.initialize(desc.getId(), properties);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.providers.put(desc.getId(), provider);
        return provider;
    }
}

