/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.bulk;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.AbstractSession;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentNotFoundException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DownloadBlobGuard;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.bulk.action.computation.AbstractBulkComputation;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.lib.stream.computation.Topology;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamProcessorTopology;

public class S3SetBlobLengthAction
implements StreamProcessorTopology {
    public static final String ACTION_NAME = "s3SetBlobLength";
    public static final String ACTION_FULL_NAME = "bulk/s3SetBlobLength";
    protected static final String FORCE_OPTION = "force";
    protected static final String XPATH_FILTER_OPTION = "xpath";

    public Topology getTopology(Map<String, String> options) {
        return Topology.builder().addComputation(SetBlobLengthComputation::new, Arrays.asList("i1:bulk/s3SetBlobLength", "o1:bulk/status")).build();
    }

    public static class SetBlobLengthComputation
    extends AbstractBulkComputation {
        private static final Logger log = LogManager.getLogger(SetBlobLengthComputation.class);

        public SetBlobLengthComputation() {
            super(S3SetBlobLengthAction.ACTION_FULL_NAME);
        }

        protected void compute(CoreSession session, List<String> ids, Map<String, Serializable> properties) {
            DownloadBlobGuard.enable();
            String xpath = (String)((Object)properties.get(S3SetBlobLengthAction.XPATH_FILTER_OPTION));
            boolean force = properties.containsKey(S3SetBlobLengthAction.FORCE_OPTION) && Boolean.parseBoolean(properties.get(S3SetBlobLengthAction.FORCE_OPTION).toString());
            for (String id : ids) {
                this.fixBlobLength((AbstractSession)session, id, xpath, force);
            }
        }

        protected void fixBlobLength(AbstractSession session, String docId, String xpath, boolean force) {
            try {
                Document doc = session.getSession().getDocumentByUUID(docId);
                if (doc == null) {
                    log.debug("Skipping doc: {} with null workingCopy.", (Object)docId);
                    return;
                }
                doc.visitBlobs(accessor -> {
                    Blob fixedBlob;
                    if (xpath != null && !xpath.equals(accessor.getXPath())) {
                        log.debug("Skipping blob xpath: {} for doc: {} because it doesn't match the xpath filter", (Object)accessor.getXPath(), (Object)docId);
                        return;
                    }
                    Blob blob = accessor.getBlob();
                    if (blob instanceof BinaryBlob && (fixedBlob = this.fixBlob(doc.getUUID(), (BinaryBlob)blob, force)) != null) {
                        accessor.setBlob(fixedBlob);
                    }
                });
            }
            catch (DocumentNotFoundException e) {
                log.debug("Skipping deleted doc: {}.", (Object)docId);
            }
            catch (PropertyException e) {
                log.warn("Cannot access blobs for doc: " + docId, (Throwable)e);
            }
        }

        protected Blob fixBlob(String docId, BinaryBlob blob, boolean force) {
            if (blob == null || blob.getKey() == null) {
                log.debug("Skipping null blob for doc: {}", (Object)docId);
                return null;
            }
            String blobKey = blob.getKey();
            long length = blob.getLength();
            if (length >= 0L && !force) {
                log.debug("Skipping blob: {} for doc: {}, keeping existing length: {}.", (Object)blobKey, (Object)docId, (Object)length);
                return null;
            }
            long fixedLength = this.getBlobLengthFromS3(docId, (Blob)blob);
            if (length == fixedLength) {
                log.debug("Skipping blob: {} for doc: {}, length is correct {}", (Object)blobKey, (Object)docId, (Object)length);
                return null;
            }
            if (fixedLength < 0L) {
                log.warn("Skipping blob: {} for doc: {}, binaryManager length: {}, keeping current value: {}.", (Object)blobKey, (Object)docId, (Object)fixedLength, (Object)length);
                return null;
            }
            log.info("Fixing length blob: {} for doc: {}, from: {} to: {}.", (Object)blob.getKey(), (Object)docId, (Object)length, (Object)fixedLength);
            return new BinaryBlob(blob.getBinary(), blob.getKey(), blob.getFilename(), blob.getMimeType(), blob.getEncoding(), blob.getDigestAlgorithm(), blob.getDigest(), fixedLength);
        }

        protected long getBlobLengthFromS3(String docId, Blob blob) {
            long length = blob.getLength();
            BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(blob);
            if (blobProvider == null) {
                log.error("Blob provider not found for doc: {}, blob: {}", (Object)docId, (Object)blob.getDigest());
            } else if (blobProvider instanceof S3BinaryManager) {
                S3BinaryManager sourceBlobProvider = (S3BinaryManager)blobProvider;
                log.debug("Fetching length from s3");
                length = sourceBlobProvider.lengthOfBlob(blob.getDigest());
            } else {
                log.debug("Not supported binary manager impl");
            }
            log.debug("Get length: {} previously: {} for doc: {}, blob: {}", (Object)length, (Object)blob.getLength(), (Object)docId, (Object)blob.getDigest());
            return length;
        }
    }
}

