/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.CopyObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.SSEAwsKeyManagementParams;
import com.amazonaws.services.s3.transfer.Copy;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicHeaderValueParser;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.handler.AbstractBatchHandler;
import org.nuxeo.ecm.automation.server.jaxrs.batch.handler.BatchFileInfo;
import org.nuxeo.ecm.blob.s3.S3ManagedTransfer;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobInfo;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobStoreBlobProvider;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.KeyStrategyDigest;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.ecm.core.storage.sql.S3Utils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;

public class S3DirectBatchHandler
extends AbstractBatchHandler {
    private static final Log log = LogFactory.getLog(S3DirectBatchHandler.class);
    @Deprecated
    public static final String ACCELERATE_MODE_ENABLED_PROPERTY = "accelerateMode";
    public static final String POLICY_TEMPLATE_PROPERTY = "policyTemplate";
    public static final String ROLE_ARN_PROPERTY = "roleArn";
    public static final String BLOB_PROVIDER_ID_PROPERTY = "blobProvider";
    public static final String INFO_AWS_SECRET_KEY_ID = "awsSecretKeyId";
    public static final String INFO_AWS_SECRET_ACCESS_KEY = "awsSecretAccessKey";
    public static final String INFO_AWS_SESSION_TOKEN = "awsSessionToken";
    public static final String INFO_BUCKET = "bucket";
    public static final String INFO_BASE_KEY = "baseKey";
    public static final String INFO_EXPIRATION = "expiration";
    public static final String INFO_AWS_ENDPOINT = "endpoint";
    public static final String INFO_AWS_PATH_STYLE_ACCESS = "usePathStyleAccess";
    public static final String INFO_AWS_REGION = "region";
    public static final String INFO_USE_S3_ACCELERATE = "useS3Accelerate";
    protected AWSSecurityTokenService stsClient;
    protected AmazonS3 amazonS3;
    protected String endpoint;
    protected boolean pathStyleAccessEnabled;
    protected String region;
    protected String bucket;
    protected String bucketPrefix;
    protected boolean accelerateModeEnabled;
    protected int expiration;
    protected String policy;
    protected String roleArn;
    protected boolean useServerSideEncryption;
    protected String serverSideKMSKeyID;
    public String blobProviderId;

    public static String getMimeType(String contentType) {
        Objects.requireNonNull(contentType);
        HeaderElement headerElement = BasicHeaderValueParser.parseHeaderElement((String)contentType, null);
        return headerElement.getName();
    }

    public static String getCharset(String contentType) {
        Objects.requireNonNull(contentType);
        HeaderElement headerElement = BasicHeaderValueParser.parseHeaderElement((String)contentType, null);
        String encoding = null;
        for (NameValuePair param : headerElement.getParameters()) {
            if (!param.getName().equalsIgnoreCase("charset")) continue;
            String s = param.getValue();
            if (StringUtils.isBlank((CharSequence)s)) break;
            encoding = s;
            break;
        }
        return encoding;
    }

    protected void initialize(Map<String, String> properties) {
        super.initialize(properties);
        this.endpoint = properties.get(INFO_AWS_ENDPOINT);
        this.pathStyleAccessEnabled = Boolean.parseBoolean(properties.get("pathstyleaccess"));
        this.region = properties.get(INFO_AWS_REGION);
        if (StringUtils.isBlank((CharSequence)this.region)) {
            this.region = NuxeoAWSRegionProvider.getInstance().getRegion();
        }
        this.bucket = properties.get(INFO_BUCKET);
        if (StringUtils.isBlank((CharSequence)this.bucket)) {
            throw new NuxeoException("Missing configuration property: bucket");
        }
        this.roleArn = properties.get(ROLE_ARN_PROPERTY);
        if (StringUtils.isBlank((CharSequence)this.roleArn)) {
            throw new NuxeoException("Missing configuration property: roleArn");
        }
        this.bucketPrefix = StringUtils.defaultString((String)properties.get("bucket_prefix"));
        this.accelerateModeEnabled = Boolean.parseBoolean(properties.get(ACCELERATE_MODE_ENABLED_PROPERTY));
        String awsSecretKeyId = properties.get("awsid");
        String awsSecretAccessKey = properties.get("awssecret");
        String awsSessionToken = properties.get("awstoken");
        this.expiration = Integer.parseInt((String)StringUtils.defaultIfEmpty((CharSequence)properties.get(INFO_EXPIRATION), (CharSequence)"0"));
        this.policy = properties.get(POLICY_TEMPLATE_PROPERTY);
        this.useServerSideEncryption = Boolean.parseBoolean(properties.get("crypt.serverside"));
        this.serverSideKMSKeyID = properties.get("crypt.kms.key");
        AWSCredentialsProvider credentials = S3Utils.getAWSCredentialsProvider(awsSecretKeyId, awsSecretAccessKey, awsSessionToken);
        this.stsClient = this.initializeSTSClient(credentials);
        this.amazonS3 = this.initializeS3Client(credentials);
        if (!StringUtils.isBlank((CharSequence)this.bucketPrefix) && !this.bucketPrefix.endsWith("/")) {
            log.debug((Object)String.format("%s %s S3 bucket prefix should end with '/': added automatically.", "bucket_prefix", this.bucketPrefix));
            this.bucketPrefix = this.bucketPrefix + "/";
        }
        this.blobProviderId = StringUtils.defaultString((String)properties.get(BLOB_PROVIDER_ID_PROPERTY), (String)this.transientStoreName);
    }

    protected AWSSecurityTokenService initializeSTSClient(AWSCredentialsProvider credentials) {
        AWSSecurityTokenServiceClientBuilder builder = AWSSecurityTokenServiceClientBuilder.standard();
        this.initializeBuilder((AwsClientBuilder<?, ?>)builder, credentials);
        return (AWSSecurityTokenService)builder.build();
    }

    protected AmazonS3 initializeS3Client(AWSCredentialsProvider credentials) {
        AmazonS3ClientBuilder builder = AmazonS3ClientBuilder.standard();
        this.initializeBuilder((AwsClientBuilder<?, ?>)builder, credentials);
        builder.setPathStyleAccessEnabled(Boolean.valueOf(this.pathStyleAccessEnabled));
        builder.setAccelerateModeEnabled(Boolean.valueOf(this.accelerateModeEnabled));
        return (AmazonS3)builder.build();
    }

    protected void initializeBuilder(AwsClientBuilder<?, ?> builder, AWSCredentialsProvider credentials) {
        if (StringUtils.isBlank((CharSequence)this.endpoint)) {
            builder.setRegion(this.region);
        } else {
            builder.setEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.endpoint, this.region));
        }
        builder.setCredentials(credentials);
    }

    public Batch getBatch(String batchId) {
        Map parameters = this.getBatchParameters(batchId);
        if (parameters == null) {
            return null;
        }
        Batch batch = new Batch(batchId, parameters, this.getName(), this.getTransientStore());
        Credentials credentials = this.getAwsCredentials(batchId);
        Map properties = batch.getProperties();
        properties.put(INFO_AWS_SECRET_KEY_ID, credentials.getAccessKeyId());
        properties.put(INFO_AWS_SECRET_ACCESS_KEY, credentials.getSecretAccessKey());
        properties.put(INFO_AWS_SESSION_TOKEN, credentials.getSessionToken());
        properties.put(INFO_BUCKET, this.bucket);
        properties.put(INFO_BASE_KEY, this.bucketPrefix);
        properties.put(INFO_EXPIRATION, credentials.getExpiration().toInstant().toEpochMilli());
        properties.put(INFO_AWS_ENDPOINT, StringUtils.defaultIfBlank((CharSequence)this.endpoint, null));
        properties.put(INFO_AWS_PATH_STYLE_ACCESS, this.pathStyleAccessEnabled);
        properties.put(INFO_AWS_REGION, this.region);
        properties.put(INFO_USE_S3_ACCELERATE, this.accelerateModeEnabled);
        return batch;
    }

    protected Credentials assumeRole(AssumeRoleRequest request) {
        return this.stsClient.assumeRole(request).getCredentials();
    }

    public boolean completeUpload(String batchId, String fileIndex, BatchFileInfo fileInfo) {
        Blob blob;
        String fileKey = fileInfo.getKey();
        Object key = StringUtils.removeStart((String)fileKey, (String)this.bucketPrefix);
        ObjectMetadata metadata = this.amazonS3.getObjectMetadata(this.bucket, fileKey);
        if (this.isValidDigest((String)key)) {
            key = metadata.getETag();
            if (this.isValidDigest((String)key)) {
                key = (String)key + "-0";
            }
            this.move(fileKey, this.bucketPrefix + (String)key);
        }
        BlobInfo blobInfo = new BlobInfo();
        String contentType = metadata.getContentType();
        blobInfo.mimeType = S3DirectBatchHandler.getMimeType(contentType);
        blobInfo.encoding = S3DirectBatchHandler.getCharset(contentType);
        blobInfo.filename = fileInfo.getFilename();
        blobInfo.length = metadata.getContentLength();
        blobInfo.key = key;
        try {
            blob = this.getBlobProvider().readBlob(blobInfo);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        Batch batch = this.getBatch(batchId);
        try {
            batch.addFile(fileIndex, blob, blob.getFilename(), blob.getMimeType());
        }
        catch (NuxeoException e) {
            try {
                this.amazonS3.deleteObject(this.bucket, this.bucketPrefix + (String)key);
            }
            catch (AmazonS3Exception s3E) {
                e.addSuppressed((Throwable)s3E);
            }
            throw e;
        }
        return true;
    }

    protected void move(String sourceKey, String destinationKey) {
        CopyObjectRequest copyObjectRequest = new CopyObjectRequest(this.bucket, sourceKey, this.bucket, destinationKey);
        if (this.useServerSideEncryption) {
            if (StringUtils.isNotBlank((CharSequence)this.serverSideKMSKeyID)) {
                SSEAwsKeyManagementParams params = new SSEAwsKeyManagementParams(this.serverSideKMSKeyID);
                copyObjectRequest.setSSEAwsKeyManagementParams(params);
            } else {
                ObjectMetadata newObjectMetadata = new ObjectMetadata();
                newObjectMetadata.setSSEAlgorithm(ObjectMetadata.AES_256_SERVER_SIDE_ENCRYPTION);
                copyObjectRequest.setNewObjectMetadata(newObjectMetadata);
            }
        }
        Copy copy = this.getTransferManager().copy(copyObjectRequest);
        try {
            copy.waitForCompletion();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new NuxeoException((Throwable)e);
        }
        finally {
            try {
                this.amazonS3.deleteObject(this.bucket, sourceKey);
            }
            catch (AmazonServiceException e) {
                log.debug((Object)"Unable to cleanup object, move has already been done", (Throwable)e);
            }
        }
    }

    protected boolean isValidDigest(String key) {
        KeyStrategy keyStrategy;
        BlobProvider blobProvider = this.getBlobProvider();
        if (blobProvider instanceof S3BinaryManager) {
            return ((S3BinaryManager)blobProvider).isValidDigest(key);
        }
        if (blobProvider instanceof BlobStoreBlobProvider && (keyStrategy = ((BlobStoreBlobProvider)blobProvider).store.getKeyStrategy()) instanceof KeyStrategyDigest) {
            return ((KeyStrategyDigest)keyStrategy).isValidDigest(key);
        }
        return false;
    }

    protected BlobProvider getBlobProvider() {
        return ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(this.blobProviderId);
    }

    protected TransferManager getTransferManager() {
        BlobProvider blobProvider = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProvider(this.blobProviderId);
        if (!(blobProvider instanceof S3ManagedTransfer)) {
            throw new NuxeoException("BlobProvider does not implement S3ManagedTransfer");
        }
        return ((S3ManagedTransfer)blobProvider).getTransferManager();
    }

    protected Credentials getAwsCredentials(String batchId) {
        AssumeRoleRequest request = new AssumeRoleRequest().withRoleArn(this.roleArn).withPolicy(this.policy).withRoleSessionName(batchId);
        if (this.expiration > 0) {
            request.setDurationSeconds(Integer.valueOf(this.expiration));
        }
        return this.assumeRole(request);
    }

    public Map<String, Object> refreshToken(String batchId) {
        Objects.requireNonNull(batchId, "required batch ID");
        Credentials credentials = this.getAwsCredentials(batchId);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(INFO_AWS_SECRET_KEY_ID, credentials.getAccessKeyId());
        result.put(INFO_AWS_SECRET_ACCESS_KEY, credentials.getSecretAccessKey());
        result.put(INFO_AWS_SESSION_TOKEN, credentials.getSessionToken());
        result.put(INFO_EXPIRATION, credentials.getExpiration().toInstant().toEpochMilli());
        return result;
    }
}

