/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.executor.jaxrs;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.importer.base.GenericMultiThreadedImporter;
import org.nuxeo.ecm.platform.importer.base.ImporterRunner;
import org.nuxeo.ecm.platform.importer.base.ImporterRunnerConfiguration;
import org.nuxeo.ecm.platform.importer.executor.jaxrs.AbstractJaxRSImporterExecutor;
import org.nuxeo.ecm.platform.importer.filter.EventServiceConfiguratorFilter;
import org.nuxeo.ecm.platform.importer.filter.ImporterFilter;
import org.nuxeo.ecm.platform.importer.service.DefaultImporterService;
import org.nuxeo.ecm.platform.importer.source.RandomTextSourceNode;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

@Path(value="randomImporter")
public class RandomImporterExecutor
extends AbstractJaxRSImporterExecutor {
    private static final Log log = LogFactory.getLog(RandomImporterExecutor.class);

    protected Log getJavaLogger() {
        return log;
    }

    @GET
    @Path(value="run")
    @Produces(value={"text/plain; charset=UTF-8"})
    public String run(@QueryParam(value="targetPath") String targetPath, @QueryParam(value="skipRootContainerCreation") Boolean skipRootContainerCreation, @QueryParam(value="batchSize") Integer batchSize, @QueryParam(value="nbThreads") Integer nbThreads, @QueryParam(value="interactive") Boolean interactive, @QueryParam(value="nbNodes") Integer nbNodes, @QueryParam(value="fileSizeKB") Integer fileSizeKB, @QueryParam(value="onlyText") Boolean onlyText, @QueryParam(value="nonUniform") Boolean nonUniform, @QueryParam(value="withProperties") Boolean withProperties, @QueryParam(value="blockSyncPostCommitProcessing") Boolean blockSyncPostCommitProcessing, @QueryParam(value="blockAsyncProcessing") Boolean blockAsyncProcessing, @QueryParam(value="blockIndexing") Boolean blockIndexing, @QueryParam(value="bulkMode") Boolean bulkMode, @QueryParam(value="transactionTimeout") Integer transactionTimeout, @QueryParam(value="lang") String lang) {
        if (onlyText == null) {
            onlyText = true;
        }
        if (nonUniform == null) {
            nonUniform = false;
        }
        if (withProperties == null) {
            withProperties = false;
        }
        if (bulkMode == null) {
            bulkMode = true;
        }
        this.getLogger().info("Init Random text generator");
        RandomTextSourceNode source = RandomTextSourceNode.init((int)nbNodes, (Integer)fileSizeKB, (boolean)onlyText, (boolean)nonUniform, (boolean)withProperties, (String)lang);
        this.getLogger().info("Random text generator initialized");
        ImporterRunnerConfiguration configuration = new ImporterRunnerConfiguration.Builder((SourceNode)source, targetPath, this.getLogger()).skipRootContainerCreation(skipRootContainerCreation).batchSize(batchSize).nbThreads(nbThreads).build();
        GenericMultiThreadedImporter runner = new GenericMultiThreadedImporter(configuration);
        runner.setEnablePerfLogging(((DefaultImporterService)Framework.getService(DefaultImporterService.class)).getEnablePerfLogging());
        EventServiceConfiguratorFilter filter = new EventServiceConfiguratorFilter(blockSyncPostCommitProcessing, blockAsyncProcessing, Boolean.valueOf(onlyText == false), blockIndexing, bulkMode);
        runner.addFilter((ImporterFilter)filter);
        if (transactionTimeout != null) {
            runner.setTransactionTimeout(transactionTimeout.intValue());
        }
        String res = this.run((ImporterRunner)runner, interactive);
        return res;
    }

    public String run(ImporterRunner runner, Boolean interactive) {
        return this.doRun(runner, interactive);
    }
}

