/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.nuxeo.common.utils.Path;
import org.nuxeo.runtime.api.Framework;

public class PerfLogger {
    protected String[] headers;
    protected File logFile;
    protected Writer logWriter;
    protected static final String SEP = ";";

    public PerfLogger(String[] headers) throws IOException {
        this.headers = headers;
        File home = Framework.getRuntime().getHome();
        String logPath = new Path(home.getAbsolutePath()).append("perfLog_" + System.currentTimeMillis() + ".csv").toString();
        this.logFile = new File(logPath);
        this.logWriter = new FileWriter(this.logFile);
        this.log(headers);
    }

    public void log(String[] data) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis());
        for (String s : data) {
            sb.append(SEP);
            sb.append("\"");
            sb.append(s);
            sb.append("\"");
        }
        sb.append("\n");
        this.logWriter.write(sb.toString());
    }

    public void log(Double[] data) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(System.currentTimeMillis());
        for (Double d : data) {
            sb.append(SEP);
            sb.append(d.toString());
        }
        sb.append("\n");
        this.logWriter.write(sb.toString());
        this.logWriter.flush();
    }

    public void release() throws IOException {
        if (this.logWriter != null) {
            this.logWriter.flush();
            this.logWriter.close();
            this.logWriter = null;
        }
    }
}

