/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.importer.source;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.platform.importer.source.SourceNode;

public class FileSourceNode
implements SourceNode {
    protected File file;

    public FileSourceNode(File file) {
        this.file = file;
    }

    public FileSourceNode(String path) {
        this.file = new File(path);
    }

    @Override
    public BlobHolder getBlobHolder() throws IOException {
        return new SimpleBlobHolder(Blobs.createBlob((File)this.file));
    }

    @Override
    public List<SourceNode> getChildren() throws IOException {
        ArrayList<SourceNode> children = new ArrayList<SourceNode>();
        for (File child : this.file.listFiles()) {
            children.add(new FileSourceNode(child));
        }
        return children;
    }

    @Override
    public boolean isFolderish() {
        return this.file.isDirectory();
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getSourcePath() {
        return this.file.getAbsolutePath();
    }

    public File getFile() {
        return this.file;
    }

    public static String getFileNameNoExt(File file) {
        String name = file.getName();
        int p = name.lastIndexOf(46);
        if (p == -1) {
            return name;
        }
        return name.substring(0, p);
    }
}

