/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.s3;

import com.amazonaws.services.s3.model.ObjectMetadata;
import com.iss.nuxeo.bulkimport.s3.S3BlobProviders;
import com.iss.nuxeo.bulkimport.s3.S3Operation;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolderWithProperties;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.LazyBinary;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;

public class S3BlobTransfer {
    private String sourceBlobProvider;
    private String transientBlobProvider;
    private String targetBlobProvider;

    private S3BlobTransfer() {
    }

    public static S3BlobTransfer withSourceBlobProvider(String id) {
        S3BlobTransfer transfer = new S3BlobTransfer();
        transfer.sourceBlobProvider = id;
        return transfer;
    }

    public S3BlobTransfer withTransientBlobProvider(String id) {
        this.transientBlobProvider = id;
        return this;
    }

    public S3BlobTransfer withTargetBlobProvider(String id) {
        this.targetBlobProvider = id;
        return this;
    }

    public BlobHolder transfer(String key, String name) {
        S3BinaryManager targets3;
        S3BinaryManager sources3 = S3BlobProviders.getS3BlobProvider(this.sourceBlobProvider);
        S3BinaryManager transients3 = S3BlobProviders.getS3BlobProvider(this.transientBlobProvider);
        if (transients3 == null) {
            transients3 = sources3;
            this.transientBlobProvider = this.sourceBlobProvider;
        }
        if ((targets3 = S3BlobProviders.getS3BlobProvider(this.targetBlobProvider)) == null) {
            targets3 = transients3;
            this.targetBlobProvider = this.transientBlobProvider;
        }
        S3Operation sourceOps = S3Operation.S3OperationBuilder.withS3BlobProvider(sources3).withBlobProviderId(this.sourceBlobProvider).build();
        S3Operation transientOps = S3Operation.S3OperationBuilder.withS3BlobProvider(transients3).withBlobProviderId(this.transientBlobProvider).build();
        S3Operation targetOps = S3Operation.S3OperationBuilder.withS3BlobProvider(targets3).withBlobProviderId(this.targetBlobProvider).build();
        String sourceKey = this.getS3Property(sources3, "bucket_prefix") + StringUtils.removeStart((String)key, (String)"/");
        ObjectMetadata sourceMeta = sourceOps.getObjectMetadata(sourceKey, false);
        String transientKey = sourceOps.isDummyETag(sourceMeta.getETag()) ? sourceOps.getUUID() : sourceMeta.getETag();
        ObjectMetadata transientMeta = transientOps.getObjectMetadata(this.getS3Property(transients3, "bucket_prefix") + transientKey, true);
        if (transientMeta == null) {
            transientMeta = transientOps.copy(this.getS3Property(sources3, "bucket"), sourceKey, this.getS3Property(transients3, "bucket"), this.getS3Property(transients3, "bucket_prefix") + transientKey, null);
        }
        String targetKey = transientMeta.getETag();
        ObjectMetadata targetMeta = targetOps.getObjectMetadata(this.getS3Property(targets3, "bucket_prefix") + targetKey, true);
        if (targetMeta == null) {
            targetMeta = targetOps.copy(this.getS3Property(transients3, "bucket"), this.getS3Property(transients3, "bucket_prefix") + transientKey, this.getS3Property(targets3, "bucket"), this.getS3Property(targets3, "bucket_prefix") + targetKey, null);
        }
        LazyBinary binary = new LazyBinary(targetKey, this.targetBlobProvider, null);
        BinaryBlob blob = new BinaryBlob((Binary)binary, targetKey, name, targetMeta.getContentType(), targetMeta.getContentEncoding(), targetMeta.getETag(), targetMeta.getContentLength());
        return new SimpleBlobHolderWithProperties((Blob)blob, null);
    }

    public String getS3Property(S3BinaryManager s3bm, String property) {
        Map properties = s3bm.getProperties();
        return (String)properties.get(property);
    }
}

