/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.CustomHeaders;
import com.amazonaws.services.cloudfront.model.OriginCustomHeader;
import com.amazonaws.services.cloudfront.model.transform.OriginCustomHeaderStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class CustomHeadersStaxUnmarshaller
implements Unmarshaller<CustomHeaders, StaxUnmarshallerContext> {
    private static CustomHeadersStaxUnmarshaller instance;

    public CustomHeaders unmarshall(StaxUnmarshallerContext context) throws Exception {
        CustomHeaders customHeaders = new CustomHeaders();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return customHeaders;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    customHeaders.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    customHeaders.withItems(new ArrayList<OriginCustomHeader>());
                    continue;
                }
                if (!context.testExpression("Items/OriginCustomHeader", targetDepth)) continue;
                customHeaders.withItems(OriginCustomHeaderStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return customHeaders;
    }

    public static CustomHeadersStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CustomHeadersStaxUnmarshaller();
        }
        return instance;
    }
}

