/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.KeyGroup;
import com.amazonaws.services.cloudfront.model.transform.KeyGroupConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class KeyGroupStaxUnmarshaller
implements Unmarshaller<KeyGroup, StaxUnmarshallerContext> {
    private static KeyGroupStaxUnmarshaller instance;

    public KeyGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        KeyGroup keyGroup = new KeyGroup();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return keyGroup;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    keyGroup.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LastModifiedTime", targetDepth)) {
                    keyGroup.setLastModifiedTime(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance((String)"iso8601").unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KeyGroupConfig", targetDepth)) continue;
                keyGroup.setKeyGroupConfig(KeyGroupConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return keyGroup;
    }

    public static KeyGroupStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new KeyGroupStaxUnmarshaller();
        }
        return instance;
    }
}

