/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;

public abstract class AbstractBinaryGarbageCollector<T extends CachingBinaryManager>
implements BinaryGarbageCollector {
    protected T binaryManager;
    protected BinaryManagerStatus status;
    protected volatile long startTime;
    protected Set<String> marked;
    protected Set<String> toDelete;

    protected AbstractBinaryGarbageCollector(T binaryManager) {
        this.binaryManager = binaryManager;
    }

    public void start() {
        if (this.startTime != 0L) {
            throw new RuntimeException("Already started");
        }
        this.startTime = System.currentTimeMillis();
        this.status = new BinaryManagerStatus();
        this.marked = null;
        this.computeToDelete();
        if (this.marked == null && this.toDelete == null) {
            throw new IllegalStateException("New class must define 'toDelete'");
        }
        if (this.marked != null && this.toDelete != null) {
            throw new IllegalStateException("New class must not define 'marked'");
        }
        ((CachingBinaryManager)this.binaryManager).fileCache.clear();
    }

    public void computeToDelete() {
        this.marked = new HashSet<String>();
        this.toDelete = null;
    }

    public void stop(boolean delete) {
        if (this.startTime == 0L) {
            throw new RuntimeException("Not started");
        }
        try {
            this.removeUnmarkedBlobsAndUpdateStatus(delete);
        }
        finally {
            this.marked = null;
            this.toDelete = null;
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }
    }

    protected void removeUnmarkedBlobsAndUpdateStatus(boolean delete) {
        Set<String> unmarked = this.getUnmarkedBlobs();
        if (delete) {
            this.binaryManager.removeBinaries(unmarked);
        }
    }

    public Set<String> getUnmarkedBlobs() {
        throw new UnsupportedOperationException();
    }

    public void mark(String digest) {
        if (this.marked != null) {
            this.marked.add(digest);
        } else {
            this.toDelete.remove(digest);
        }
    }

    public BinaryManagerStatus getStatus() {
        return this.status;
    }

    public boolean isInProgress() {
        return this.startTime != 0L;
    }
}

