/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.operations;

import io.maretha.summary.services.SummaryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.GenerateSummaryOperation", category="Document", label="Generate Summary", description="Generate summary using AI.")
public class GenerateSummaryOperation {
    public static final String ID = "Document.GenerateSummaryOperation";
    private final Log log = LogFactory.getLog(GenerateSummaryOperation.class);

    @OperationMethod
    public void run(DocumentModel doc) {
        this.log.debug((Object)("Triggered Operation: Document.GenerateSummaryOperationfor docId: " + doc.getId()));
        if (this.blobIsSupportedMimeType(doc) && !doc.hasFacet("SummaryFacet")) {
            doc.addFacet("SummaryFacet");
            doc.getCoreSession().saveDocument(doc);
        }
        boolean processSummary = ((SummaryService)Framework.getService(SummaryService.class)).processForSummarization(doc);
        if (this.log.isDebugEnabled()) {
            if (processSummary) {
                this.log.debug((Object)("Summary produced for document: " + doc.getId()));
            } else {
                this.log.debug((Object)("Document too big, splitting text in chunks and summarizing: " + doc.getId()));
            }
        }
    }

    private boolean blobIsSupportedMimeType(DocumentModel doc) {
        try {
            Property blobProperty = doc.getProperty("file:content");
            Blob blob = (Blob)blobProperty.getValue();
            String mimeType = blob.getMimeType();
            return ((SummaryService)Framework.getService(SummaryService.class)).getSupportedMimeTypes().contains(mimeType);
        }
        catch (Exception ex) {
            return false;
        }
    }
}

