/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.services;

import java.util.List;
import okhttp3.MediaType;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;

public interface SummaryService {
    public static final String[] MIME_TYPES_CONVERTIBLE_TO_PFD = new String[]{"application/msword", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/csv", "application/vnd.ms-excel", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/msword"};
    public static final String TEXT_MIME_TYPE = "text/plain";
    public static final String PDF_MIME_TYPE = "application/pdf";
    public static final int MAX_DELAY = Integer.parseInt(Framework.getProperty((String)"summary.extraction.http.sec-max-delay", (String)"60"));
    public static final String MODEL = Framework.getProperty((String)"summary.extraction.openai.model", (String)"text-davinci-003");
    public static final String ERROR_MESSAGE = "NOT PROCESSED, RETRYING";
    public static final String SUMMARY_AUTO_GENERATION_ENABLED_PROPERTY = "feature.summary.auto.generation.enabled";
    public static final int MAX_APPROXIMATE_REQUEST_SIZE_FOR_REQUEST_PER_MODEL = Integer.parseInt(Framework.getProperty((String)"summary.extraction.openai.max.request.bytes", (String)"40000"));
    public static final String MODEL_TOKENS_LIMIT = Framework.getProperty((String)"summary.extraction.openai.model.tokens.limit", (String)"4097");
    public static final String TEMPERATURE = Framework.getProperty((String)"summary.extraction.openai.temperature", (String)"0.3");
    public static final String MAX_TOKENS_IN_RESPONSE = Framework.getProperty((String)"summary.extraction.openai.response.max-tokens", (String)"200");
    public static final String TOP_P = Framework.getProperty((String)"summary.extraction.openai.top-p", (String)"1");
    public static final String FREQUENCY_PENALTY = Framework.getProperty((String)"summary.extraction.openai.frequency-penalty", (String)"0");
    public static final String PRESENCE_PENALTY = Framework.getProperty((String)"summary.extraction.openai.presence-penalty", (String)"0");
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String AUTH_TOKEN = Framework.getProperty((String)"openai.token");
    public static final String KVS = "kv";
    public static final String SUMMARY_FACET = "SummaryFacet";
    public static final String FILE_CONTENT = "file:content";
    public static final String SUMMARY_PROPERTY = "summary:summary";
    public static final String SUMMARY_LAST_COMPUTED_PROPERTY = "summary:lastComputed";
    public static final String SUMMARY_STATUS = "summary:status";
    public static final String KAFKA_RECORD_PATTERN = "DOC%sPAGE%sTEXT%s";

    public String summarizeText(String var1);

    public void saveSummary(String var1, String var2);

    public void saveStatus(String var1, String var2);

    public boolean processForSummarization(DocumentModel var1);

    public List<String> getSupportedMimeTypes();

    public String formatPageTextForProcessing(String var1, int var2, String var3);

    default public boolean isSummaryAutoGenerationEnabled() {
        return Boolean.parseBoolean(Framework.getProperty((String)SUMMARY_AUTO_GENERATION_ENABLED_PROPERTY, (String)"true"));
    }
}

