/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.stream;

import io.maretha.summary.services.SummaryService;
import java.util.HashMap;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.message.BulkCommand;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.lib.stream.computation.AbstractComputation;
import org.nuxeo.lib.stream.computation.ComputationContext;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueService;
import org.nuxeo.runtime.kv.KeyValueStore;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;

public class SummaryDoneComputation
extends AbstractComputation {
    public static final String SUMMARY_COMPLETION = "bulk/summaryCompletion";
    private static final Log log = LogFactory.getLog(SummaryDoneComputation.class);
    protected Codec<BulkStatus> codec;
    private SummaryService summaryService;
    private KeyValueStore kvStore;

    public SummaryDoneComputation() {
        super(SUMMARY_COMPLETION, 1, 1);
    }

    public void init(ComputationContext context) {
        super.init(context);
        this.codec = BulkCodecs.getStatusCodec();
    }

    public void processRecord(ComputationContext context, String inputStream, Record record) {
        BulkStatus status = (BulkStatus)this.codec.decode(record.getData());
        if ("summaryStream".equals(status.getAction()) && BulkStatus.State.COMPLETED.equals((Object)status.getState())) {
            BulkService bulkService = (BulkService)Framework.getService(BulkService.class);
            BulkCommand command = bulkService.getCommand(status.getId());
            StringBuilder summaryBuilder = new StringBuilder();
            HashMap processed = new HashMap();
            if (command != null) {
                String docId = (String)command.getParam("docId");
                ((KeyValueStoreProvider)this.getKVS()).keyStream().filter(key -> key.startsWith(command.getId())).forEach(key -> {
                    Integer pageNo = Integer.valueOf(key.split(":")[1]);
                    String summary = this.getKVS().getString(key);
                    processed.put(pageNo, summary);
                });
                TreeMap<Integer, String> sorterMap = new TreeMap<Integer, String>(processed);
                sorterMap.forEach((key, value) -> summaryBuilder.append("#").append(key).append(". ").append((String)value).append(" "));
                if (StringUtils.isNotEmpty((CharSequence)docId)) {
                    this.getSummaryService().saveSummary(summaryBuilder.toString(), docId);
                }
                log.debug((Object)("SummaryDoneComputation for docID: " + docId));
            }
        }
    }

    private KeyValueStore getKVS() {
        if (this.kvStore == null) {
            this.kvStore = ((KeyValueService)Framework.getService(KeyValueService.class)).getKeyValueStore("kv");
        }
        return this.kvStore;
    }

    private SummaryService getSummaryService() {
        if (this.summaryService == null) {
            this.summaryService = (SummaryService)Framework.getService(SummaryService.class);
        }
        return this.summaryService;
    }
}

