/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.status;

import java.util.Map;
import org.nuxeo.ecm.blob.s3.S3BlobProvider;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.management.api.Probe;
import org.nuxeo.runtime.management.api.ProbeStatus;

public class S3BinaryManagerStatusProbe
implements Probe {
    public ProbeStatus run() {
        Map providers = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProviders();
        boolean found = false;
        for (Map.Entry en : providers.entrySet()) {
            String id = (String)en.getKey();
            BlobProvider blobProvider = (BlobProvider)en.getValue();
            BinaryManager bm = blobProvider.getBinaryManager();
            if (bm instanceof S3BinaryManager) {
                if (!((S3BinaryManager)bm).canAccessBucket()) {
                    return ProbeStatus.newFailure((String)("S3BinaryManager cannot access the configured bucket: " + id));
                }
                found = true;
                continue;
            }
            if (!(bm instanceof S3BlobProvider)) continue;
            if (!((S3BlobProvider)bm).canAccessBucket()) {
                return ProbeStatus.newFailure((String)("S3BinaryManager cannot access the configured bucket: " + id));
            }
            found = true;
        }
        if (found) {
            return ProbeStatus.newSuccess((String)"S3BinaryManager can access the configured buckets");
        }
        return ProbeStatus.newSuccess((String)"No S3BinaryManager bucket configured");
    }
}

