/*
 * Decompiled with CFR 0.152.
 */
package io.maretha.summary.listeners;

import io.maretha.summary.services.SummaryService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class SummaryListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SummaryListener.class);
    public static final String DISABLE_SUMMARY_LISTENER = "disableSummaryListener";

    public static void fireEvent(CoreSession session, DocumentModel document, String eventName) {
        DocumentEventContext ctx = new DocumentEventContext(session, session.getPrincipal(), document);
        Event event = ctx.newEvent(eventName);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        CoreSession session = doc.getCoreSession();
        if (Boolean.TRUE.equals(doc.getContextData().get(DISABLE_SUMMARY_LISTENER))) {
            return;
        }
        if (!((SummaryService)Framework.getService(SummaryService.class)).isSummaryAutoGenerationEnabled()) {
            log.debug((Object)"Auto summary generation is disabled by configuration");
            return;
        }
        if (!doc.hasSchema("file")) {
            return;
        }
        if (("documentCreated".equals(event.getName()) || "documentImported".equals(event.getName())) && this.blobIsSupportedMimeType(doc)) {
            this.addFacetAndTriggerEvent(doc, session);
            return;
        }
        if ("beforeDocumentModification".equals(event.getName()) && this.blobIsDirty(doc) && this.blobIsSupportedMimeType(doc)) {
            this.addFacetAndTriggerEvent(doc, session);
        }
    }

    private void addFacetAndTriggerEvent(DocumentModel doc, CoreSession session) {
        if (!doc.hasFacet("SummaryFacet")) {
            doc.addFacet("SummaryFacet");
        }
        SummaryListener.fireEvent(session, doc, "extractSummaryEvent");
    }

    private boolean blobIsSupportedMimeType(DocumentModel doc) {
        try {
            Property blobProperty = doc.getProperty("file:content");
            Blob blob = (Blob)blobProperty.getValue();
            String mimeType = blob.getMimeType();
            return ((SummaryService)Framework.getService(SummaryService.class)).getSupportedMimeTypes().contains(mimeType);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean blobIsDirty(DocumentModel doc) {
        try {
            Property blobProperty = doc.getProperty("file:content");
            Blob blob = (Blob)blobProperty.getValue();
            if (blob != null && blobProperty.isDirty()) {
                return true;
            }
        }
        catch (PropertyException ex) {
            return false;
        }
        return false;
    }
}

