/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Builder;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.AmazonS3EncryptionClientBuilder;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationRequest;
import com.amazonaws.services.s3.model.GetObjectLockConfigurationResult;
import com.amazonaws.services.s3.model.ObjectLockConfiguration;
import com.amazonaws.services.s3.model.ObjectLockEnabled;
import com.amazonaws.services.s3.model.ObjectLockRetentionMode;
import com.amazonaws.services.s3.model.StaticEncryptionMaterialsProvider;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.time.Duration;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.concurrent.ThreadFactories;
import org.nuxeo.ecm.blob.CloudBlobStoreConfiguration;
import org.nuxeo.ecm.blob.s3.CloudFrontConfiguration;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.storage.sql.S3Utils;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.aws.AWSConfigurationService;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class S3BlobStoreConfiguration
extends CloudBlobStoreConfiguration {
    private static final Logger log = LogManager.getLogger(S3BlobStoreConfiguration.class);
    public static final String SYSTEM_PROPERTY_PREFIX = "nuxeo.s3storage";
    public static final String BUCKET_NAME_PROPERTY = "bucket";
    public static final String BUCKET_PREFIX_PROPERTY = "bucket_prefix";
    public static final String BUCKET_SUB_DIRS_DEPTH_PROPERTY = "subDirsDepth";
    public static final String BUCKET_REGION_PROPERTY = "region";
    public static final String AWS_ID_PROPERTY = "awsid";
    public static final String AWS_SECRET_PROPERTY = "awssecret";
    public static final String AWS_SESSION_TOKEN_PROPERTY = "awstoken";
    public static final String CONNECTION_MAX_PROPERTY = "connection.max";
    public static final String CONNECTION_RETRY_PROPERTY = "connection.retry";
    public static final String CONNECTION_TIMEOUT_PROPERTY = "connection.timeout";
    public static final String SOCKET_TIMEOUT_PROPERTY = "socket.timeout";
    public static final String KEYSTORE_FILE_PROPERTY = "crypt.keystore.file";
    public static final String KEYSTORE_PASS_PROPERTY = "crypt.keystore.password";
    public static final String SERVERSIDE_ENCRYPTION_PROPERTY = "crypt.serverside";
    public static final String SERVERSIDE_ENCRYPTION_KMS_KEY_PROPERTY = "crypt.kms.key";
    public static final String PRIVKEY_ALIAS_PROPERTY = "crypt.key.alias";
    public static final String PRIVKEY_PASS_PROPERTY = "crypt.key.password";
    public static final String ENDPOINT_PROPERTY = "endpoint";
    public static final String PATHSTYLEACCESS_PROPERTY = "pathstyleaccess";
    public static final String ACCELERATE_MODE_PROPERTY = "accelerateMode";
    public static final String DIRECTDOWNLOAD_PROPERTY_COMPAT = "downloadfroms3";
    public static final String DIRECTDOWNLOAD_EXPIRE_PROPERTY_COMPAT = "downloadfroms3.expire";
    public static final String METADATA_ADD_USERNAME_PROPERTY = "metadata.addusername";
    public static final String MULTIPART_CLEANUP_DISABLED_PROPERTY = "multipart.cleanup.disabled";
    public static final String DELIMITER = "/";
    public static final String MULTIPART_COPY_PART_SIZE_CONFIGURATION_PROPERTY = "nuxeo.s3.multipart.copy.part.size";
    public static final String MULTIPART_COPY_PART_SIZE_PROPERTY = "nuxeo.s3storage.multipart.copy.part.size";
    public static final long MULTIPART_COPY_PART_SIZE_DEFAULT = 0x500000L;
    public static final String MULTIPART_COPY_THRESHOLD_PROPERTY = "nuxeo.s3storage.multipart.copy.threshold";
    public static final long MULTIPART_COPY_THRESHOLD_DEFAULT = 0x140000000L;
    public static final String MULTIPART_UPLOAD_THRESHOLD_PROPERTY = "nuxeo.s3storage.multipart.upload.threshold";
    public static final long MULTIPART_UPLOAD_THRESHOLD_DEFAULT = 0x1000000L;
    public static final String MINIMUM_UPLOAD_PART_SIZE_PROPERTY = "nuxeo.s3storage.minimum.upload.part.size";
    public static final long MINIMUM_UPLOAD_PART_SIZE_DEFAULT = 0x500000L;
    public static final String TRANSFER_MANAGER_THREAD_POOL_SIZE_PROPERTY = "nuxeo.s3storage.transfer.manager.thread.pool.size";
    public static final int TRANSFER_MANAGER_THREAD_POOL_SIZE_DEFAULT = 10;
    public static final String DISABLE_PROXY_PROPERTY = "nuxeo.s3.proxy.disabled";
    public static final String USER_AGENT_PREFIX_PROPERTY = "userAgentPrefix";
    public static final String USER_AGENT_SUFFIX_PROPERTY = "userAgentSuffix";
    public static final ObjectLockRetentionMode DEFAULT_RETENTION_MODE = ObjectLockRetentionMode.GOVERNANCE;
    public final CloudFrontConfiguration cloudFront;
    public final AmazonS3 amazonS3;
    public final TransferManager transferManager;
    public final String bucketName;
    public final String bucketPrefix;
    public final boolean useServerSideEncryption;
    public final String serverSideKMSKeyID;
    public final boolean useClientSideEncryption;
    public final boolean metadataAddUsername;
    public final boolean s3RetentionEnabled;
    public final ObjectLockRetentionMode retentionMode;

    public S3BlobStoreConfiguration(Map<String, String> properties) throws IOException {
        super(SYSTEM_PROPERTY_PREFIX, properties);
        AmazonS3Builder s3Builder;
        this.cloudFront = new CloudFrontConfiguration(SYSTEM_PROPERTY_PREFIX, properties);
        this.bucketName = this.getBucketName();
        this.bucketPrefix = this.getBucketPrefix();
        String sseprop = this.getProperty(SERVERSIDE_ENCRYPTION_PROPERTY);
        if (StringUtils.isNotBlank((CharSequence)sseprop)) {
            this.useServerSideEncryption = Boolean.parseBoolean(sseprop);
            this.serverSideKMSKeyID = this.getProperty(SERVERSIDE_ENCRYPTION_KMS_KEY_PROPERTY);
        } else {
            this.useServerSideEncryption = false;
            this.serverSideKMSKeyID = null;
        }
        AWSCredentialsProvider awsCredentialsProvider = this.getAWSCredentialsProvider();
        ClientConfiguration clientConfiguration = this.getClientConfiguration();
        EncryptionMaterials encryptionMaterials = this.getEncryptionMaterials();
        boolean bl = this.useClientSideEncryption = encryptionMaterials != null;
        if (this.useClientSideEncryption) {
            CryptoConfiguration cryptoConfiguration = new CryptoConfiguration();
            s3Builder = ((AmazonS3EncryptionClientBuilder)((AmazonS3EncryptionClientBuilder)AmazonS3EncryptionClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(clientConfiguration)).withCryptoConfiguration(cryptoConfiguration).withEncryptionMaterials((EncryptionMaterialsProvider)new StaticEncryptionMaterialsProvider(encryptionMaterials));
        } else {
            s3Builder = (AmazonS3Builder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials(awsCredentialsProvider)).withClientConfiguration(clientConfiguration);
        }
        this.configurePathStyleAccess(s3Builder);
        this.configureRegionOrEndpoint(s3Builder);
        this.configureAccelerateMode(s3Builder);
        this.amazonS3 = this.getAmazonS3(s3Builder);
        this.metadataAddUsername = this.getBooleanProperty(METADATA_ADD_USERNAME_PROPERTY);
        this.s3RetentionEnabled = this.isS3RetentionEnabled();
        ObjectLockRetentionMode objectLockRetentionMode = this.retentionMode = Framework.isBooleanPropertyTrue((String)"nuxeo.retention.compliance.enabled") ? ObjectLockRetentionMode.COMPLIANCE : ObjectLockRetentionMode.GOVERNANCE;
        if (!this.s3RetentionEnabled && Boolean.parseBoolean(properties.get("record"))) {
            log.warn("Blob provider is configured for records but retention is not enabled on s3 bucket {}", (Object)this.bucketName);
        }
        this.transferManager = this.createTransferManager();
        this.abortOldUploads();
    }

    public S3BlobStoreConfiguration withNamespace(String ns) throws IOException {
        return new S3BlobStoreConfiguration(this.propertiesWithNamespace(ns));
    }

    public void close() {
        this.transferManager.shutdownNow();
    }

    public static long getMultipartCopyPartSize() {
        Optional optional;
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        if (configurationService != null && (optional = configurationService.getLong(MULTIPART_COPY_PART_SIZE_CONFIGURATION_PROPERTY)).isPresent()) {
            return (Long)optional.get();
        }
        return S3BlobStoreConfiguration.getLongProperty(MULTIPART_COPY_PART_SIZE_PROPERTY, 0x500000L);
    }

    public static long getLongProperty(String key, long defaultValue) {
        String value = Framework.getProperty((String)key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            log.error("Invalid framework property: {}={}, expecting a long value.", (Object)key, (Object)value, (Object)e);
            return defaultValue;
        }
    }

    protected boolean parseDirectDownload() {
        String directDownloadCompat = this.getProperty(DIRECTDOWNLOAD_PROPERTY_COMPAT);
        if (directDownloadCompat != null) {
            return Boolean.parseBoolean(directDownloadCompat);
        }
        return super.parseDirectDownload();
    }

    protected long parseDirectDownloadExpire() {
        int directDownloadExpireCompat = this.getIntProperty(DIRECTDOWNLOAD_EXPIRE_PROPERTY_COMPAT);
        if (directDownloadExpireCompat >= 0) {
            return directDownloadExpireCompat;
        }
        return super.parseDirectDownloadExpire();
    }

    protected String getBucketName() {
        String bn = this.getProperty(BUCKET_NAME_PROPERTY);
        if (StringUtils.isBlank((CharSequence)bn)) {
            throw new NuxeoException("Missing configuration: bucket");
        }
        return bn;
    }

    protected String getBucketPrefix() {
        Object value = (String)this.properties.get(BUCKET_PREFIX_PROPERTY);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = "";
        } else if (!((String)value).endsWith(DELIMITER)) {
            log.debug("{} {} S3 bucket prefix should end with '/': added automatically.", (Object)BUCKET_PREFIX_PROPERTY, value);
            value = (String)value + DELIMITER;
        }
        if (StringUtils.isNotBlank((CharSequence)this.namespace) && !((String)(value = (String)value + this.namespace)).endsWith(DELIMITER)) {
            value = (String)value + DELIMITER;
        }
        return value;
    }

    protected int getSubDirsDepth() {
        int d = this.getIntProperty(BUCKET_SUB_DIRS_DEPTH_PROPERTY);
        if (d < 0) {
            d = 0;
        }
        return d;
    }

    protected AWSCredentialsProvider getAWSCredentialsProvider() {
        String awsID = this.getProperty(AWS_ID_PROPERTY);
        String awsSecret = this.getProperty(AWS_SECRET_PROPERTY);
        String awsToken = this.getProperty(AWS_SESSION_TOKEN_PROPERTY);
        return S3Utils.getAWSCredentialsProvider(awsID, awsSecret, awsToken);
    }

    protected ClientConfiguration getClientConfiguration() {
        AWSConfigurationService service;
        boolean proxyDisabled = Framework.isBooleanPropertyTrue((String)DISABLE_PROXY_PROPERTY);
        String proxyHost = Framework.getProperty((String)"nuxeo.http.proxy.host");
        String proxyPort = Framework.getProperty((String)"nuxeo.http.proxy.port");
        String proxyLogin = Framework.getProperty((String)"nuxeo.http.proxy.login");
        String proxyPassword = Framework.getProperty((String)"nuxeo.http.proxy.password");
        int maxConnections = this.getIntProperty(CONNECTION_MAX_PROPERTY);
        int maxErrorRetry = this.getIntProperty(CONNECTION_RETRY_PROPERTY);
        int connectionTimeout = this.getIntProperty(CONNECTION_TIMEOUT_PROPERTY);
        int socketTimeout = this.getIntProperty(SOCKET_TIMEOUT_PROPERTY);
        String userAgentPrefix = this.getProperty(USER_AGENT_PREFIX_PROPERTY);
        String userAgentSuffix = this.getProperty(USER_AGENT_SUFFIX_PROPERTY);
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (!proxyDisabled) {
            if (StringUtils.isNotBlank((CharSequence)proxyHost)) {
                clientConfiguration.setProxyHost(proxyHost);
            }
            if (StringUtils.isNotBlank((CharSequence)proxyPort)) {
                clientConfiguration.setProxyPort(Integer.parseInt(proxyPort));
            }
            if (StringUtils.isNotBlank((CharSequence)proxyLogin)) {
                clientConfiguration.setProxyUsername(proxyLogin);
            }
            if (proxyPassword != null) {
                clientConfiguration.setProxyPassword(proxyPassword);
            }
        }
        if (maxConnections > 0) {
            clientConfiguration.setMaxConnections(maxConnections);
        }
        if (maxErrorRetry >= 0) {
            clientConfiguration.setMaxErrorRetry(maxErrorRetry);
        }
        if (connectionTimeout >= 0) {
            clientConfiguration.setConnectionTimeout(connectionTimeout);
        }
        if (socketTimeout >= 0) {
            clientConfiguration.setSocketTimeout(socketTimeout);
        }
        if (StringUtils.isNotBlank((CharSequence)userAgentPrefix)) {
            clientConfiguration.setUserAgentPrefix(userAgentPrefix);
        }
        if (StringUtils.isNotBlank((CharSequence)userAgentSuffix)) {
            clientConfiguration.setUserAgentSuffix(userAgentSuffix);
        }
        if ((service = (AWSConfigurationService)Framework.getService(AWSConfigurationService.class)) != null) {
            service.configureSSL(clientConfiguration);
        }
        return clientConfiguration;
    }

    protected EncryptionMaterials getEncryptionMaterials() {
        String keystoreFile = this.getProperty(KEYSTORE_FILE_PROPERTY);
        String keystorePass = this.getProperty(KEYSTORE_PASS_PROPERTY);
        String privkeyAlias = this.getProperty(PRIVKEY_ALIAS_PROPERTY);
        String privkeyPass = this.getProperty(PRIVKEY_PASS_PROPERTY);
        if (StringUtils.isBlank((CharSequence)keystoreFile)) {
            return null;
        }
        boolean confok = true;
        if (keystorePass == null) {
            log.error("Keystore password missing");
            confok = false;
        }
        if (StringUtils.isBlank((CharSequence)privkeyAlias)) {
            log.error("Key alias missing");
            confok = false;
        }
        if (privkeyPass == null) {
            log.error("Key password missing");
            confok = false;
        }
        if (!confok) {
            throw new NuxeoException("S3 Crypto configuration incomplete");
        }
        try {
            KeyStore keystore;
            File ksFile = new File(keystoreFile);
            try (FileInputStream ksStream = new FileInputStream(ksFile);){
                keystore = KeyStore.getInstance(KeyStore.getDefaultType());
                keystore.load(ksStream, keystorePass.toCharArray());
            }
            if (!keystore.isKeyEntry(privkeyAlias)) {
                throw new NuxeoException("Alias " + privkeyAlias + " is missing or not a key alias");
            }
            PrivateKey privKey = (PrivateKey)keystore.getKey(privkeyAlias, privkeyPass.toCharArray());
            Certificate cert = keystore.getCertificate(privkeyAlias);
            PublicKey pubKey = cert.getPublicKey();
            KeyPair keypair = new KeyPair(pubKey, privKey);
            return new EncryptionMaterials(keypair);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new NuxeoException("Could not read keystore: " + keystoreFile + ", alias: " + privkeyAlias, (Throwable)e);
        }
    }

    protected void configurePathStyleAccess(AmazonS3Builder<?, ?> s3Builder) {
        boolean pathStyleAccessEnabled = this.getBooleanProperty(PATHSTYLEACCESS_PROPERTY);
        if (pathStyleAccessEnabled) {
            log.debug("Path-style access enabled");
            s3Builder.enablePathStyleAccess();
        }
    }

    protected void configureRegionOrEndpoint(AmazonS3Builder<?, ?> s3Builder) {
        String endpoint;
        String bucketRegion = this.getProperty(BUCKET_REGION_PROPERTY);
        if (StringUtils.isBlank((CharSequence)bucketRegion)) {
            bucketRegion = NuxeoAWSRegionProvider.getInstance().getRegion();
        }
        if (StringUtils.isNotBlank((CharSequence)(endpoint = this.getProperty(ENDPOINT_PROPERTY)))) {
            s3Builder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, bucketRegion));
        } else {
            s3Builder.withRegion(bucketRegion);
        }
    }

    protected void configureAccelerateMode(AmazonS3Builder<?, ?> s3Builder) {
        boolean accelerateModeEnabled = this.getBooleanProperty(ACCELERATE_MODE_PROPERTY);
        if (accelerateModeEnabled) {
            log.debug("Accelerate mode enabled");
            s3Builder.enableAccelerateMode();
        }
    }

    protected AmazonS3 getAmazonS3(AmazonS3Builder<?, ?> s3Builder) {
        return (AmazonS3)s3Builder.build();
    }

    protected TransferManager createTransferManager() {
        boolean alwaysCalculateMultipartMd5 = this.s3RetentionEnabled;
        return TransferManagerBuilder.standard().withS3Client(this.amazonS3).withMinimumUploadPartSize(Long.valueOf(S3BlobStoreConfiguration.getLongProperty(MINIMUM_UPLOAD_PART_SIZE_PROPERTY, 0x500000L))).withMultipartUploadThreshold(Long.valueOf(S3BlobStoreConfiguration.getLongProperty(MULTIPART_UPLOAD_THRESHOLD_PROPERTY, 0x1000000L))).withMultipartCopyThreshold(Long.valueOf(S3BlobStoreConfiguration.getLongProperty(MULTIPART_COPY_THRESHOLD_PROPERTY, 0x140000000L))).withMultipartCopyPartSize(Long.valueOf(S3BlobStoreConfiguration.getMultipartCopyPartSize())).withAlwaysCalculateMultipartMd5(alwaysCalculateMultipartMd5).withExecutorFactory(() -> Executors.newFixedThreadPool((int)S3BlobStoreConfiguration.getLongProperty(TRANSFER_MANAGER_THREAD_POOL_SIZE_PROPERTY, 10L), ThreadFactories.newThreadFactory((String)"s3-transfer-manager-worker"))).build();
    }

    @Deprecated
    protected ObjectLockRetentionMode getRetentionMode() {
        return this.retentionMode;
    }

    protected boolean isS3RetentionEnabled() {
        GetObjectLockConfigurationResult result;
        GetObjectLockConfigurationRequest request = new GetObjectLockConfigurationRequest().withBucketName(this.bucketName);
        try {
            result = this.amazonS3.getObjectLockConfiguration(request);
        }
        catch (AmazonServiceException e) {
            log.debug("Failed to get ObjectLockConfiguration for bucket: {}", (Object)this.bucketName, (Object)e);
            return false;
        }
        ObjectLockConfiguration olc = result.getObjectLockConfiguration();
        if (olc != null) {
            return ObjectLockEnabled.ENABLED.toString().equals(olc.getObjectLockEnabled());
        }
        return false;
    }

    protected void abortOldUploads() {
        if (this.getBooleanProperty(MULTIPART_CLEANUP_DISABLED_PROPERTY)) {
            log.debug("Cleanup of old multipart uploads is disabled");
            return;
        }
        new Thread(this::abortOldMultipartUploadsInternal, "Nuxeo-S3-abortOldMultipartUploads-" + this.bucketName).start();
    }

    protected void abortOldMultipartUploadsInternal() {
        long oneDay = Duration.ofDays(1L).toMillis();
        try {
            log.debug("Starting cleanup of old multipart uploads for bucket: {}", (Object)this.bucketName);
            Date oneDayAgo = new Date(System.currentTimeMillis() - oneDay);
            this.transferManager.abortMultipartUploads(this.bucketName, oneDayAgo);
            log.debug("Cleanup done for bucket: {}", (Object)this.bucketName);
        }
        catch (AmazonServiceException e) {
            if (e.getStatusCode() == 400 || e.getStatusCode() == 404) {
                log.warn("Aborting old uploads is not supported by this provider", (Throwable)e);
                return;
            }
            throw new NuxeoException("Failed to abort old uploads", (Throwable)e);
        }
    }
}

