/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob.s3;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.HttpMethod;
import com.amazonaws.services.cloudfront.CloudFrontUrlSigner;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import com.amazonaws.services.s3.model.GeneratePresignedUrlRequest;
import com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.StorageClass;
import com.amazonaws.services.s3.transfer.TransferManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivateKey;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.common.utils.RFC2231;
import org.nuxeo.ecm.blob.s3.CloudFrontConfiguration;
import org.nuxeo.ecm.blob.s3.S3BlobStore;
import org.nuxeo.ecm.blob.s3.S3BlobStoreConfiguration;
import org.nuxeo.ecm.blob.s3.S3ManagedTransfer;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobStatus;
import org.nuxeo.ecm.core.blob.BlobStore;
import org.nuxeo.ecm.core.blob.BlobStoreBlobProvider;
import org.nuxeo.ecm.core.blob.CachingBlobStore;
import org.nuxeo.ecm.core.blob.KeyStrategy;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.TransactionalBlobStore;
import org.nuxeo.ecm.core.io.download.DownloadHelper;

public class S3BlobProvider
extends BlobStoreBlobProvider
implements S3ManagedTransfer {
    private static final Logger log = LogManager.getLogger(S3BlobProvider.class);
    public S3BlobStoreConfiguration config;

    protected BlobStore getBlobStore(String blobProviderId, Map<String, String> properties) throws IOException {
        boolean caching;
        this.config = this.getConfiguration(properties);
        log.info("Registering S3 blob provider '" + blobProviderId);
        KeyStrategy keyStrategy = this.getKeyStrategy();
        S3BlobStore store = new S3BlobStore(blobProviderId, "S3", this.config, keyStrategy);
        boolean bl = caching = !this.config.getBooleanProperty("nocache");
        if (caching) {
            store = new CachingBlobStore(blobProviderId, "Cache", (BlobStore)store, this.config.cachingConfiguration);
        }
        if (this.isTransactional()) {
            S3BlobStore transientStore;
            if (store.hasVersioning()) {
                transientStore = store;
            } else {
                S3BlobStoreConfiguration transientConfig = this.config.withNamespace("tx");
                transientStore = new S3BlobStore(blobProviderId, "S3_tmp", transientConfig, keyStrategy);
                if (caching) {
                    transientStore = new CachingBlobStore(blobProviderId, "Cache_tmp", (BlobStore)transientStore, this.config.cachingConfiguration);
                }
            }
            store = new TransactionalBlobStore(blobProviderId, (BlobStore)store, (BlobStore)transientStore);
        }
        return store;
    }

    protected S3BlobStoreConfiguration getConfiguration(Map<String, String> properties) throws IOException {
        return new S3BlobStoreConfiguration(properties);
    }

    @Override
    public TransferManager getTransferManager() {
        return this.config.transferManager;
    }

    public void close() {
        this.config.close();
    }

    protected String getDigestAlgorithm() {
        return this.config.digestConfiguration.digestAlgorithm;
    }

    public boolean canAccessBucket() {
        return this.config.amazonS3.doesBucketExistV2(this.config.bucketName);
    }

    public URI getURI(ManagedBlob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        if (hint != BlobManager.UsageHint.DOWNLOAD || !this.config.directDownload) {
            return null;
        }
        String bucketKey = this.config.bucketPrefix + this.stripBlobKeyPrefix(blob.getKey());
        Date expiration = new Date(System.currentTimeMillis() + this.config.directDownloadExpire * 1000L);
        try {
            if (this.config.cloudFront.enabled) {
                return this.getURICloudFront(bucketKey, blob, expiration);
            }
            return this.getURIS3(bucketKey, blob, expiration);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    protected URI getURICloudFront(String bucketKey, ManagedBlob blob, Date expiration) throws URISyntaxException {
        String[] parts = bucketKey.split(String.valueOf('@'));
        bucketKey = parts[0];
        CloudFrontConfiguration cloudFront = this.config.cloudFront;
        SignerUtils.Protocol protocol = cloudFront.protocol;
        String baseURI = protocol == SignerUtils.Protocol.http || protocol == SignerUtils.Protocol.https ? protocol + "://" + cloudFront.distributionDomain + "/" + bucketKey : bucketKey;
        URIBuilder uriBuilder = new URIBuilder(baseURI);
        if (parts.length > 1) {
            uriBuilder.addParameter("versionId", parts[1]);
        }
        uriBuilder.addParameter("response-content-type", this.getContentTypeHeader((Blob)blob));
        uriBuilder.addParameter("response-content-disposition", this.getContentDispositionHeader((Blob)blob));
        if (cloudFront.fixEncoding) {
            for (NameValuePair p : uriBuilder.getQueryParams()) {
                String value = p.getValue();
                if (value == null || !value.contains(" ")) continue;
                uriBuilder.setParameter(p.getName(), value.replace(" ", ""));
            }
        }
        URI uri = uriBuilder.build();
        if (cloudFront.privateKey == null) {
            return uri;
        }
        String signedURL = CloudFrontUrlSigner.getSignedURLWithCannedPolicy((String)uri.toString(), (String)cloudFront.keyPairId, (PrivateKey)cloudFront.privateKey, (Date)expiration);
        return new URI(signedURL);
    }

    protected URI getURIS3(String bucketKey, ManagedBlob blob, Date expiration) throws URISyntaxException {
        String[] parts = bucketKey.split(String.valueOf('@'));
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(this.config.bucketName, parts[0], HttpMethod.GET);
        if (parts.length > 1) {
            request.setVersionId(parts[1]);
        }
        request.addRequestParameter("response-content-type", this.getContentTypeHeader((Blob)blob));
        request.addRequestParameter("response-content-disposition", this.getContentDispositionHeader((Blob)blob));
        request.setExpiration(expiration);
        URL url = this.config.amazonS3.generatePresignedUrl(request);
        return url.toURI();
    }

    protected String getContentTypeHeader(Blob blob) {
        return DownloadHelper.getContentTypeHeader((Blob)blob);
    }

    protected String getContentDispositionHeader(Blob blob) {
        return RFC2231.encodeContentDisposition((String)blob.getFilename(), (boolean)false, null);
    }

    public BlobStatus getStatus(ManagedBlob blob) throws IOException {
        Date date;
        ObjectMetadata metadata;
        String versionId;
        String objectKey;
        String key = this.stripBlobKeyPrefix(blob.getKey());
        int seppos = key.indexOf(64);
        if (seppos < 0) {
            objectKey = key;
            versionId = null;
        } else {
            objectKey = key.substring(0, seppos);
            versionId = key.substring(seppos + 1);
        }
        String bucketKey = this.config.bucketPrefix + objectKey;
        GetObjectMetadataRequest request = new GetObjectMetadataRequest(this.config.bucketName, bucketKey, versionId);
        try {
            metadata = this.config.amazonS3.getObjectMetadata(request);
        }
        catch (AmazonServiceException e) {
            if (S3BlobStore.isMissingKey(e)) {
                log.error("Failed to get information on blob: {}", (Object)key, (Object)e);
                return new BlobStatus().withDownloadable(false);
            }
            throw new IOException(e);
        }
        String storageClass = metadata.getStorageClass();
        if (StorageClass.Standard.toString().equals(storageClass)) {
            storageClass = null;
        }
        Instant downloadableUntil = (date = metadata.getRestoreExpirationTime()) == null ? null : date.toInstant();
        boolean downloadable = storageClass == null || downloadableUntil != null;
        boolean ongoingRestore = BooleanUtils.isTrue((Boolean)metadata.getOngoingRestore());
        return new BlobStatus().withStorageClass(storageClass).withDownloadable(downloadable).withDownloadableUntil(downloadableUntil).withOngoingRestore(ongoingRestore);
    }
}

