/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.Signer;
import com.amazonaws.services.cloudfront.model.transform.KeyPairIdsStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SignerStaxUnmarshaller
implements Unmarshaller<Signer, StaxUnmarshallerContext> {
    private static SignerStaxUnmarshaller instance;

    public Signer unmarshall(StaxUnmarshallerContext context) throws Exception {
        Signer signer = new Signer();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return signer;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("AwsAccountNumber", targetDepth)) {
                    signer.setAwsAccountNumber(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("KeyPairIds", targetDepth)) continue;
                signer.setKeyPairIds(KeyPairIdsStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return signer;
    }

    public static SignerStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SignerStaxUnmarshaller();
        }
        return instance;
    }
}

