/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.nuxeo.runtime.aws.AWSConfigurationDescriptor;
import org.nuxeo.runtime.aws.AWSConfigurationService;
import org.nuxeo.runtime.model.DefaultComponent;

public class AWSConfigurationServiceImpl
extends DefaultComponent
implements AWSConfigurationService {
    public static final String XP_CONFIGURATION = "configuration";

    @Override
    public AWSCredentials getAWSCredentials(String id) {
        AWSConfigurationDescriptor descriptor = (AWSConfigurationDescriptor)this.getDescriptor(XP_CONFIGURATION, (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)"default"));
        if (descriptor != null) {
            String accessKeyId = descriptor.getAccessKeyId();
            String secretKey = descriptor.getSecretKey();
            String sessionToken = descriptor.getSessionToken();
            if (StringUtils.isNotBlank((CharSequence)accessKeyId) && StringUtils.isNotBlank((CharSequence)secretKey)) {
                if (StringUtils.isNotBlank((CharSequence)sessionToken)) {
                    return new BasicSessionCredentials(accessKeyId, secretKey, sessionToken);
                }
                return new BasicAWSCredentials(accessKeyId, secretKey);
            }
        }
        return null;
    }

    @Override
    public String getAWSRegion(String id) {
        String region;
        AWSConfigurationDescriptor descriptor = (AWSConfigurationDescriptor)this.getDescriptor(XP_CONFIGURATION, (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)"default"));
        if (descriptor != null && StringUtils.isNotBlank((CharSequence)(region = descriptor.getRegion()))) {
            return region;
        }
        return null;
    }

    @Override
    public void configureSSL(String id, ClientConfiguration config) {
        SSLContext sslContext = this.getSSLContext((AWSConfigurationDescriptor)this.getDescriptor(XP_CONFIGURATION, (String)StringUtils.defaultIfBlank((CharSequence)id, (CharSequence)"default")));
        if (sslContext != null) {
            SSLConnectionSocketFactory factory = new SSLConnectionSocketFactory(sslContext);
            config.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)factory);
        }
    }

    protected SSLContext getSSLContext(AWSConfigurationDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        try {
            KeyStore trustStore = this.loadKeyStore(descriptor.trustStorePath, descriptor.trustStorePassword, descriptor.trustStoreType);
            KeyStore keyStore = this.loadKeyStore(descriptor.keyStorePath, descriptor.keyStorePassword, descriptor.keyStoreType);
            if (trustStore == null && keyStore == null) {
                return null;
            }
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (trustStore != null) {
                sslContextBuilder.loadTrustMaterial(trustStore, null);
            }
            if (keyStore != null) {
                sslContextBuilder.loadKeyMaterial(keyStore, StringUtils.isBlank((CharSequence)descriptor.keyStorePassword) ? null : descriptor.keyStorePassword.toCharArray());
            }
            return sslContextBuilder.build();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Cannot setup SSL context", e);
        }
    }

    protected KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
        if (StringUtils.isBlank((CharSequence)path)) {
            return null;
        }
        String keyStoreType = (String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType());
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
        try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
            keyStore.load(is, passwordChars);
        }
        return keyStore;
    }
}

