/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSClusterInvalidator;

public class DBSRepositoryDescriptor
implements Cloneable {
    @XNode(value="@name")
    public String name;
    @XNode(value="@label")
    public String label;
    @XNode(value="@isDefault")
    protected Boolean isDefault;
    @XNode(value="@headless")
    protected Boolean headless;
    @XNode(value="idType")
    public String idType;
    protected FulltextDescriptor fulltextDescriptor = new FulltextDescriptor();
    @XNode(value="cache@enabled")
    private Boolean cacheEnabled;
    @XNode(value="cache@ttl")
    public Long cacheTTL;
    @XNode(value="cache@maxSize")
    public Long cacheMaxSize;
    @XNode(value="cache@concurrencyLevel")
    public Integer cacheConcurrencyLevel;
    @XNode(value="clustering@id")
    public String clusterNodeId;
    @XNode(value="clustering@enabled")
    private Boolean clusteringEnabled;
    @XNode(value="clustering/invalidatorClass")
    public Class<? extends DBSClusterInvalidator> clusterInvalidatorClass;
    @XNode(value="changeTokenEnabled")
    private Boolean changeTokenEnabled;

    public Boolean isDefault() {
        return this.isDefault;
    }

    public Boolean isHeadless() {
        return this.headless;
    }

    public FulltextDescriptor getFulltextDescriptor() {
        return this.fulltextDescriptor;
    }

    @XNode(value="fulltext@fieldSizeLimit")
    public void setFulltextFieldSizeLimit(int fieldSizeLimit) {
        this.fulltextDescriptor.setFulltextFieldSizeLimit(fieldSizeLimit);
    }

    @XNode(value="fulltext@disabled")
    public void setFulltextDisabled(boolean disabled) {
        this.fulltextDescriptor.setFulltextDisabled(disabled);
    }

    @XNode(value="fulltext@storedInBlob")
    public void setFulltextStoredInBlob(boolean storedInBlob) {
        this.fulltextDescriptor.setFulltextStoredInBlob(storedInBlob);
    }

    @XNode(value="fulltext@searchDisabled")
    public void setFulltextSearchDisabled(boolean disabled) {
        this.fulltextDescriptor.setFulltextSearchDisabled(disabled);
    }

    @XNodeList(value="fulltext/index", type=ArrayList.class, componentType=FulltextDescriptor.FulltextIndexDescriptor.class)
    public void setFulltextIndexes(List<FulltextDescriptor.FulltextIndexDescriptor> fulltextIndexes) {
        this.fulltextDescriptor.setFulltextIndexes(fulltextIndexes);
    }

    @XNodeList(value="fulltext/excludedTypes/type", type=HashSet.class, componentType=String.class)
    public void setFulltextExcludedTypes(Set<String> fulltextExcludedTypes) {
        this.fulltextDescriptor.setFulltextExcludedTypes(fulltextExcludedTypes);
    }

    @XNodeList(value="fulltext/includedTypes/type", type=HashSet.class, componentType=String.class)
    public void setFulltextIncludedTypes(Set<String> fulltextIncludedTypes) {
        this.fulltextDescriptor.setFulltextIncludedTypes(fulltextIncludedTypes);
    }

    public boolean isCacheEnabled() {
        return DBSRepositoryDescriptor.defaultFalse(this.cacheEnabled);
    }

    protected void setCacheEnabled(boolean enabled) {
        this.cacheEnabled = enabled;
    }

    public boolean isClusteringEnabled() {
        return DBSRepositoryDescriptor.defaultFalse(this.clusteringEnabled);
    }

    protected void setClusteringEnabled(boolean enabled) {
        this.clusteringEnabled = enabled;
    }

    public boolean isChangeTokenEnabled() {
        return DBSRepositoryDescriptor.defaultFalse(this.changeTokenEnabled);
    }

    public void setChangeTokenEnabled(boolean enabled) {
        this.changeTokenEnabled = enabled;
    }

    public DBSRepositoryDescriptor clone() {
        try {
            DBSRepositoryDescriptor clone = (DBSRepositoryDescriptor)super.clone();
            clone.fulltextDescriptor = new FulltextDescriptor(this.fulltextDescriptor);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void merge(DBSRepositoryDescriptor other) {
        if (other.name != null) {
            this.name = other.name;
        }
        if (other.label != null) {
            this.label = other.label;
        }
        if (other.isDefault != null) {
            this.isDefault = other.isDefault;
        }
        if (other.idType != null) {
            this.idType = other.idType;
        }
        this.fulltextDescriptor.merge(other.fulltextDescriptor);
        if (other.cacheEnabled != null) {
            this.cacheEnabled = other.cacheEnabled;
        }
        if (other.cacheTTL != null) {
            this.cacheTTL = other.cacheTTL;
        }
        if (other.cacheMaxSize != null) {
            this.cacheMaxSize = other.cacheMaxSize;
        }
        if (other.cacheConcurrencyLevel != null) {
            this.cacheConcurrencyLevel = other.cacheConcurrencyLevel;
        }
        if (other.clusterNodeId != null) {
            this.clusterNodeId = other.clusterNodeId;
        }
        if (other.clusteringEnabled != null) {
            this.clusteringEnabled = other.clusteringEnabled;
        }
        if (other.clusterInvalidatorClass != null) {
            this.clusterInvalidatorClass = other.clusterInvalidatorClass;
        }
        if (other.changeTokenEnabled != null) {
            this.changeTokenEnabled = other.changeTokenEnabled;
        }
    }

    private static boolean defaultFalse(Boolean bool) {
        return Boolean.TRUE.equals(bool);
    }
}

