/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.dbs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import javax.resource.spi.ConnectionManager;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.repository.FulltextConfiguration;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.model.Session;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConstants;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.storage.FulltextConfigurationFactory;
import org.nuxeo.ecm.core.storage.FulltextDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSRepository;
import org.nuxeo.ecm.core.storage.dbs.DBSRepositoryDescriptor;
import org.nuxeo.ecm.core.storage.dbs.DBSSession;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public abstract class DBSRepositoryBase
implements DBSRepository {
    private static final Log log = LogFactory.getLog(DBSRepositoryBase.class);
    public static final String TYPE_ROOT = "Root";
    protected final boolean DEBUG_UUIDS = false;
    private static final String UUID_ZERO = "00000000-0000-0000-0000-000000000000";
    private static final String UUID_ZERO_DEBUG = "UUID_0";
    protected IdType idType;
    protected final String repositoryName;
    protected final FulltextConfiguration fulltextConfiguration;
    protected final BlobManager blobManager;
    protected LockManager lockManager;
    protected final ConnectionManager cm;
    protected final boolean changeTokenEnabled;
    protected final Map<String, Object> capabilities = new HashMap<String, Object>();
    protected boolean selfRegisteredLockManager = false;
    protected List<List<String>> blobKeysPaths;
    public Map<Transaction, TransactionContext> transactionContexts = new ConcurrentHashMap<Transaction, TransactionContext>();

    public DBSRepositoryBase(ConnectionManager cm, String repositoryName, DBSRepositoryDescriptor descriptor) {
        this.repositoryName = repositoryName;
        String idt = descriptor.idType;
        List<IdType> allowed = this.getAllowedIdTypes();
        if (StringUtils.isBlank((CharSequence)idt)) {
            idt = allowed.get(0).name();
        }
        try {
            this.idType = IdType.valueOf(idt);
            if (!allowed.contains((Object)this.idType)) {
                throw new IllegalArgumentException("Invalid id type: " + idt);
            }
        }
        catch (IllegalArgumentException e) {
            throw new NuxeoException("Unknown id type: " + idt + ", allowed: " + allowed);
        }
        FulltextDescriptor fulltextDescriptor = descriptor.getFulltextDescriptor();
        this.fulltextConfiguration = fulltextDescriptor.getFulltextDisabled() ? null : FulltextConfigurationFactory.make((FulltextDescriptor)fulltextDescriptor);
        this.cm = cm;
        this.changeTokenEnabled = descriptor.isChangeTokenEnabled();
        this.blobManager = (BlobManager)Framework.getService(BlobManager.class);
        this.initBlobsPaths();
        this.initLockManager();
    }

    public abstract List<IdType> getAllowedIdTypes();

    public void shutdown() {
        LockManagerService lms;
        try {
            NuxeoContainer.disposeConnectionManager((ConnectionManager)this.cm);
        }
        catch (RuntimeException e) {
            LogFactory.getLog(ConnectionFactoryImpl.class).warn((Object)("cannot dispose connection manager of " + this.repositoryName));
        }
        if (this.selfRegisteredLockManager && (lms = (LockManagerService)Framework.getService(LockManagerService.class)) != null) {
            lms.unregisterLockManager(this.getLockManagerName());
        }
    }

    public String getName() {
        return this.repositoryName;
    }

    public FulltextConfiguration getFulltextConfiguration() {
        return this.fulltextConfiguration;
    }

    protected String getLockManagerName() {
        return this.getName();
    }

    protected void initLockManager() {
        String lockManagerName = this.getLockManagerName();
        LockManagerService lockManagerService = (LockManagerService)Framework.getService(LockManagerService.class);
        this.lockManager = lockManagerService.getLockManager(lockManagerName);
        if (this.lockManager == null) {
            this.lockManager = this;
            log.info((Object)("Repository " + this.repositoryName + " using own lock manager"));
            lockManagerService.registerLockManager(lockManagerName, this.lockManager);
            this.selfRegisteredLockManager = true;
        } else {
            this.selfRegisteredLockManager = false;
            log.info((Object)("Repository " + this.repositoryName + " using lock manager " + this.lockManager));
        }
    }

    @Override
    public LockManager getLockManager() {
        return this.lockManager;
    }

    @Override
    public List<List<String>> getBlobKeysPaths() {
        return this.blobKeysPaths;
    }

    protected void initBlobsPaths() {
        BlobFinder finder = new BlobFinder();
        finder.visit();
        if (this.isFulltextStoredInBlob()) {
            finder.visitFulltextStoredInBlob();
        }
        this.blobKeysPaths = finder.blobKeysPaths;
    }

    public void initRoot() {
        Session session = this.getSession();
        Document root = session.importDocument(this.getRootId(), null, "", TYPE_ROOT, new HashMap());
        ACLImpl acl = new ACLImpl();
        acl.add(new ACE("administrators", "Everything", true));
        acl.add(new ACE("Administrator", "Everything", true));
        acl.add(new ACE("members", "Read", true));
        ACPImpl acp = new ACPImpl();
        acp.addACL((ACL)acl);
        session.setACP(root, (ACP)acp, true);
        session.save();
        session.close();
        if (TransactionHelper.isTransactionActive()) {
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
    }

    @Override
    public String getRootId() {
        switch (this.idType) {
            case varchar: 
            case uuid: {
                return UUID_ZERO;
            }
            case sequence: {
                return "0";
            }
            case sequenceHexRandomized: {
                return "0000000000000000";
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public BlobManager getBlobManager() {
        return this.blobManager;
    }

    @Override
    public boolean isFulltextDisabled() {
        return this.fulltextConfiguration == null;
    }

    @Override
    public boolean isFulltextStoredInBlob() {
        return this.fulltextConfiguration != null && this.fulltextConfiguration.fulltextStoredInBlob;
    }

    @Override
    public boolean isFulltextSearchDisabled() {
        return this.isFulltextDisabled() || this.isFulltextStoredInBlob() || this.fulltextConfiguration.fulltextSearchDisabled;
    }

    @Override
    public boolean isChangeTokenEnabled() {
        return this.changeTokenEnabled;
    }

    public Object getCapability(String name) {
        return this.capabilities.get(name);
    }

    public int getActiveSessionsCount() {
        return this.transactionContexts.size();
    }

    public Session getSession() {
        return this.getSession(this);
    }

    protected Session getSession(DBSRepository repository) {
        Transaction transaction;
        try {
            transaction = TransactionHelper.lookupTransactionManager().getTransaction();
            if (transaction == null) {
                throw new NuxeoException("Missing transaction");
            }
            int status = transaction.getStatus();
            if (status != 0 && status != 1) {
                throw new NuxeoException("Transaction in invalid state: " + status);
            }
        }
        catch (NamingException | SystemException e) {
            throw new NuxeoException("Failed to get transaction", e);
        }
        TransactionContext context = this.transactionContexts.get(transaction);
        if (context == null) {
            context = new TransactionContext(transaction, this.newSession(repository));
            context.init();
        }
        return context.newSession();
    }

    protected DBSSession newSession(DBSRepository repository) {
        return new DBSSession(repository);
    }

    public static class DBSSessionInvoker
    implements InvocationHandler {
        private static final String METHOD_HASHCODE = "hashCode";
        private static final String METHOD_EQUALS = "equals";
        private static final String METHOD_CLOSE = "close";
        private static final String METHOD_ISLIVE = "isLive";
        protected final TransactionContext context;
        protected boolean closed;

        public DBSSessionInvoker(TransactionContext context) {
            this.context = context;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (methodName.equals(METHOD_HASHCODE)) {
                return this.doHashCode();
            }
            if (methodName.equals(METHOD_EQUALS)) {
                return this.doEquals(args);
            }
            if (methodName.equals(METHOD_CLOSE)) {
                return this.doClose(proxy);
            }
            if (methodName.equals(METHOD_ISLIVE)) {
                return this.doIsLive();
            }
            if (this.closed) {
                throw new NuxeoException("Cannot use closed connection handle");
            }
            try {
                return method.invoke((Object)this.context.baseSession, args);
            }
            catch (ReflectiveOperationException e) {
                throw ExceptionUtils.unwrapInvoke((Exception)e);
            }
        }

        protected Integer doHashCode() {
            return this.hashCode();
        }

        protected Boolean doEquals(Object[] args) {
            if (args.length != 1 || args[0] == null) {
                return Boolean.FALSE;
            }
            Object other = args[0];
            if (!Proxy.isProxyClass(other.getClass())) {
                return Boolean.FALSE;
            }
            InvocationHandler otherInvoker = Proxy.getInvocationHandler(other);
            return this.equals(otherInvoker);
        }

        protected Object doClose(Object proxy) {
            this.closed = true;
            this.context.remove(proxy);
            return null;
        }

        protected Boolean doIsLive() {
            if (this.closed) {
                return Boolean.FALSE;
            }
            return this.context.baseSession.isLive();
        }
    }

    public class TransactionContext
    implements Synchronization {
        protected final Transaction transaction;
        protected final DBSSession baseSession;
        protected final Set<Session> proxies;

        public TransactionContext(Transaction transaction, DBSSession baseSession) {
            this.transaction = transaction;
            this.baseSession = baseSession;
            this.proxies = new HashSet<Session>();
        }

        public void init() {
            DBSRepositoryBase.this.transactionContexts.put(this.transaction, this);
            this.begin();
            try {
                this.transaction.registerSynchronization((Synchronization)this);
            }
            catch (RollbackException | SystemException e) {
                throw new RuntimeException(e);
            }
        }

        public Session newSession() {
            ClassLoader cl = this.getClass().getClassLoader();
            DBSSessionInvoker invoker = new DBSSessionInvoker(this);
            Session proxy = (Session)Proxy.newProxyInstance(cl, new Class[]{Session.class}, (InvocationHandler)invoker);
            this.add(proxy);
            return proxy;
        }

        public void add(Session proxy) {
            this.proxies.add(proxy);
        }

        public boolean remove(Object proxy) {
            return this.proxies.remove(proxy);
        }

        public void begin() {
            this.baseSession.begin();
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                this.baseSession.commit();
            } else if (status == 4) {
                this.baseSession.rollback();
            } else {
                log.error((Object)("Unexpected afterCompletion status: " + status));
            }
            this.baseSession.close();
            this.removeTransaction();
        }

        protected void removeTransaction() {
            for (Session proxy : this.proxies.toArray(new Session[0])) {
                proxy.close();
            }
            DBSRepositoryBase.this.transactionContexts.remove(this.transaction);
        }
    }

    protected static class BlobFinder {
        protected final Set<String> schemaDone = new HashSet<String>();
        protected final Deque<String> path = new ArrayDeque<String>();
        protected List<List<String>> blobKeysPaths = new ArrayList<List<String>>();

        protected BlobFinder() {
        }

        public void visit() {
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            for (DocumentType documentType : schemaManager.getDocumentTypes()) {
                this.visitSchemas(documentType.getSchemas());
            }
            for (DocumentType documentType : schemaManager.getFacets()) {
                this.visitSchemas(documentType.getSchemas());
            }
        }

        public void visitFulltextStoredInBlob() {
            this.path.addLast("ecm:fulltextBinary");
            this.recordBlobPath();
            this.path.removeLast();
        }

        protected void visitSchemas(Collection<Schema> schemas) {
            for (Schema schema : schemas) {
                if (!this.schemaDone.add(schema.getName())) continue;
                this.visitComplexType((ComplexType)schema);
            }
        }

        protected void visitComplexType(ComplexType complexType) {
            if (TypeConstants.isContentType((Type)complexType)) {
                this.path.addLast("data");
                this.recordBlobPath();
                this.path.removeLast();
                return;
            }
            for (Field field : complexType.getFields()) {
                this.visitField(field);
            }
        }

        protected void recordBlobPath() {
            this.blobKeysPaths.add(new ArrayList<String>(this.path));
        }

        protected void visitField(Field field) {
            Type type = field.getType();
            if (!type.isSimpleType()) {
                if (type.isComplexType()) {
                    String name = field.getName().getPrefixedName();
                    this.path.addLast(name);
                    this.visitComplexType((ComplexType)type);
                    this.path.removeLast();
                } else {
                    Type fieldType = ((ListType)type).getFieldType();
                    if (!fieldType.isSimpleType()) {
                        String name = field.getName().getPrefixedName();
                        this.path.addLast(name);
                        this.visitComplexType((ComplexType)fieldType);
                        this.path.removeLast();
                    }
                }
            }
        }
    }

    public static enum IdType {
        varchar,
        uuid,
        sequence,
        sequenceHexRandomized;

    }
}

