/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb;

import com.mongodb.DB;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientURI;
import com.mongodb.ServerAddress;
import com.mongodb.gridfs.GridFS;
import java.net.UnknownHostException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class MongoDBClientFactory {
    protected String server;
    protected String dbname;
    private String bucket;
    protected MongoClient client;

    public MongoDBClientFactory() {
    }

    public MongoDBClientFactory(String server, String dbname, String bucket) {
        this();
        this.server = server;
        this.dbname = dbname;
        this.bucket = bucket;
    }

    protected String getServer() {
        if (StringUtils.isBlank((CharSequence)this.server)) {
            this.server = Framework.getProperty((String)"nuxeo.mongodb.server");
        }
        return this.server;
    }

    protected String getDBName() {
        if (StringUtils.isBlank((CharSequence)this.dbname)) {
            this.dbname = Framework.getProperty((String)"nuxeo.mongodb.dbname");
        }
        return this.dbname;
    }

    protected String getBucket() {
        if (StringUtils.isBlank((CharSequence)this.bucket)) {
            this.bucket = Framework.getProperty((String)"nuxeo.mongodb.gridfs.bucket");
            if (StringUtils.isBlank((CharSequence)this.bucket)) {
                this.bucket = "fs";
            }
        }
        return this.bucket;
    }

    public void dispose() {
        if (this.client != null) {
            this.client.close();
        }
    }

    public MongoClient initClient() throws UnknownHostException {
        if (this.client == null) {
            this.client = this.getServer().startsWith("mongodb://") ? new MongoClient(new MongoClientURI(this.getServer())) : new MongoClient(new ServerAddress(this.getServer()));
        }
        return this.client;
    }

    public MongoClient getClient() {
        if (this.client == null) {
            try {
                this.initClient();
            }
            catch (UnknownHostException e) {
                throw new NuxeoException("Unable to init MongoDB client", (Throwable)e);
            }
        }
        return this.client;
    }

    public DB getDB() {
        return this.getClient().getDB(this.getDBName());
    }

    public GridFS instanciateGridFS() {
        return new GridFS(this.getDB(), this.getBucket());
    }
}

