/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.mongodb.blob;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.gridfs.GridFS;
import com.mongodb.gridfs.GridFSDBFile;
import com.mongodb.gridfs.GridFSInputFile;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.AbstractBinaryManager;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.storage.mongodb.MongoDBClientFactory;
import org.nuxeo.runtime.api.Framework;

public class GridFSBinaryManager
extends AbstractBinaryManager
implements BlobProvider {
    protected MongoClient client;
    protected GridFS gridFS;
    protected Map<String, String> properties;

    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.properties = properties;
        String server = properties.get("server");
        String dbname = properties.get("dbname");
        String bucket = properties.get("bucket");
        MongoDBClientFactory factory = new MongoDBClientFactory(server, dbname, bucket);
        this.client = factory.getClient();
        this.gridFS = factory.instanciateGridFS();
        this.garbageCollector = new GridFSBinaryGarbageCollector();
    }

    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }

    protected Binary getBinary(InputStream stream) throws IOException {
        GridFSInputFile gFile = this.gridFS.createFile(stream, true);
        gFile.save();
        String digest = gFile.getMD5();
        long length = gFile.getLength();
        GridFSDBFile existingFile = this.gridFS.findOne(digest);
        if (existingFile == null) {
            gFile.setFilename(digest);
            gFile.save();
        } else {
            this.gridFS.remove((DBObject)gFile);
        }
        return new GridFSBinary(digest, length, this.blobProviderId);
    }

    public Binary getBinary(String digest) {
        GridFSDBFile dbFile = this.gridFS.findOne(digest);
        if (dbFile != null) {
            return new GridFSBinary(digest, dbFile.getLength(), this.blobProviderId);
        }
        return null;
    }

    public Blob readBlob(BlobManager.BlobInfo blobInfo) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).readBlob(blobInfo);
    }

    public String writeBlob(Blob blob, Document doc) throws IOException {
        return new BinaryBlobProvider((BinaryManager)this).writeBlob(blob, doc);
    }

    public boolean supportsUserUpdate() {
        return !Boolean.parseBoolean(this.properties.get("preventUserUpdate"));
    }

    public GridFS getGridFS() {
        return this.gridFS;
    }

    public class GridFSBinaryGarbageCollector
    implements BinaryGarbageCollector {
        protected BinaryManagerStatus status;
        protected volatile long startTime;
        protected static final String MARK_KEY_PREFIX = "gc-mark-key-";
        protected String msKey;

        public String getId() {
            return "gridfs:" + GridFSBinaryManager.this.getGridFS().getBucketName();
        }

        public BinaryManagerStatus getStatus() {
            return this.status;
        }

        public boolean isInProgress() {
            return this.startTime != 0L;
        }

        public void mark(String digest) {
            GridFSDBFile dbFile = GridFSBinaryManager.this.gridFS.findOne(digest);
            if (dbFile != null) {
                BasicDBObject meta = new BasicDBObject();
                meta.put(this.msKey, (Object)true);
                dbFile.setMetaData((DBObject)meta);
                dbFile.save();
                ++this.status.numBinaries;
                this.status.sizeBinaries += dbFile.getLength();
            }
        }

        public void start() {
            if (this.startTime != 0L) {
                throw new RuntimeException("Already started");
            }
            this.startTime = System.currentTimeMillis();
            this.status = new BinaryManagerStatus();
            this.msKey = MARK_KEY_PREFIX + System.currentTimeMillis();
        }

        public void stop(boolean delete) {
            BasicDBObject query = new BasicDBObject("metadata." + this.msKey, (Object)new BasicDBObject("$exists", (Object)false));
            List files = GridFSBinaryManager.this.gridFS.find((DBObject)query);
            for (GridFSDBFile file : files) {
                ++this.status.numBinariesGC;
                this.status.sizeBinariesGC += file.getLength();
                if (!delete) continue;
                GridFSBinaryManager.this.gridFS.remove((DBObject)file);
            }
            this.startTime = 0L;
        }
    }

    protected class GridFSBinary
    extends Binary {
        private static final long serialVersionUID = 1L;
        protected final long length;

        protected GridFSBinary(String digest, long length, String blobProviderId) {
            super(digest, blobProviderId);
            this.length = length;
        }

        public long getLength() {
            return this.length;
        }

        public InputStream getStream() {
            GridFSDBFile dbFile = GridFSBinaryManager.this.gridFS.findOne(this.digest);
            return dbFile.getInputStream();
        }

        public File getFile() {
            if (this.file == null || !this.file.exists()) {
                try {
                    this.file = File.createTempFile("nuxeo-gridfs-", ".bin");
                    GridFSDBFile dbFile = GridFSBinaryManager.this.gridFS.findOne(this.digest);
                    IOUtils.copy((InputStream)dbFile.getInputStream(), (OutputStream)new FileOutputStream(this.file));
                    Framework.trackFile((File)this.file, (Object)((Object)this));
                }
                catch (IOException e) {
                    throw new NuxeoException("Unable to extract file from GridFS Stream", (Throwable)e);
                }
            }
            return this.file;
        }
    }
}

