/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.dao;

import com.mongodb.MongoWriteException;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.result.DeleteResult;
import com.novemberain.quartz.mongodb.JobConverter;
import com.novemberain.quartz.mongodb.util.GroupHelper;
import com.novemberain.quartz.mongodb.util.Keys;
import com.novemberain.quartz.mongodb.util.QueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.impl.matchers.GroupMatcher;

public class JobDao {
    private final MongoCollection<Document> jobCollection;
    private final QueryHelper queryHelper;
    private final GroupHelper groupHelper;
    private final JobConverter jobConverter;

    public JobDao(MongoCollection<Document> jobCollection, QueryHelper queryHelper, JobConverter jobConverter) {
        this.jobCollection = jobCollection;
        this.queryHelper = queryHelper;
        this.groupHelper = new GroupHelper(jobCollection, queryHelper);
        this.jobConverter = jobConverter;
    }

    public MongoCollection<Document> getCollection() {
        return this.jobCollection;
    }

    public DeleteResult clear() {
        return this.jobCollection.deleteMany((Bson)new Document());
    }

    public void createIndex() {
        this.jobCollection.createIndex(Keys.KEY_AND_GROUP_FIELDS, new IndexOptions().unique(true));
    }

    public void dropIndex() {
        this.jobCollection.dropIndex("keyName_1_keyGroup_1");
    }

    public boolean exists(JobKey jobKey) {
        return this.jobCollection.count(Keys.toFilter(jobKey)) > 0L;
    }

    public Document getById(Object id) {
        return (Document)this.jobCollection.find(Filters.eq((String)"_id", (Object)id)).first();
    }

    public Document getJob(Bson keyObject) {
        return (Document)this.jobCollection.find(keyObject).first();
    }

    public Document getJob(JobKey key) {
        return this.getJob(Keys.toFilter(key));
    }

    public int getCount() {
        return (int)this.jobCollection.count();
    }

    public List<String> getGroupNames() {
        return (List)this.jobCollection.distinct("keyGroup", String.class).into(new ArrayList());
    }

    public Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) {
        HashSet<JobKey> keys = new HashSet<JobKey>();
        Bson query = this.queryHelper.matchingKeysConditionFor(matcher);
        for (Document doc : this.jobCollection.find(query).projection(Keys.KEY_AND_GROUP_FIELDS)) {
            keys.add(Keys.toJobKey(doc));
        }
        return keys;
    }

    public Collection<ObjectId> idsOfMatching(GroupMatcher<JobKey> matcher) {
        ArrayList<ObjectId> list = new ArrayList<ObjectId>();
        for (Document doc : this.findMatching(matcher)) {
            list.add(doc.getObjectId((Object)"_id"));
        }
        return list;
    }

    public void remove(Bson keyObject) {
        this.jobCollection.deleteMany(keyObject);
    }

    public boolean requestsRecovery(JobKey jobKey) {
        Document jobDoc = this.getJob(jobKey);
        return jobDoc.getBoolean((Object)"requestsRecovery", false);
    }

    public JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        Document doc = this.getJob(jobKey);
        if (doc == null) {
            return null;
        }
        return this.jobConverter.toJobDetail(doc);
    }

    public ObjectId storeJobInMongo(JobDetail newJob, boolean replaceExisting) throws JobPersistenceException {
        JobKey key = newJob.getKey();
        Bson keyDbo = Keys.toFilter(key);
        Document job = this.jobConverter.toDocument(newJob, key);
        Document object = this.getJob(keyDbo);
        ObjectId objectId = null;
        if (object != null && replaceExisting) {
            this.jobCollection.replaceOne(keyDbo, (Object)job);
        } else if (object == null) {
            try {
                this.jobCollection.insertOne((Object)job);
                objectId = job.getObjectId((Object)"_id");
            }
            catch (MongoWriteException e) {
                object = this.getJob(keyDbo);
                objectId = object.getObjectId((Object)"_id");
            }
        } else {
            objectId = object.getObjectId((Object)"_id");
        }
        return objectId;
    }

    private Collection<Document> findMatching(GroupMatcher<JobKey> matcher) {
        return this.groupHelper.inGroupsThatMatch(matcher);
    }
}

