/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.db;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.MongoCredential;
import com.mongodb.MongoException;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.quartz.SchedulerConfigException;

public class MongoConnector {
    private MongoClient mongo;

    private MongoConnector() {
    }

    public void shutdown() {
        this.mongo.close();
    }

    public MongoDatabase selectDatabase(String dbName) {
        return this.mongo.getDatabase(dbName);
    }

    public static MongoConnectorBuilder builder() {
        return new MongoConnectorBuilder();
    }

    public static class MongoConnectorBuilder {
        private MongoConnector connector = new MongoConnector();
        private MongoClientOptions.Builder optionsBuilder = MongoClientOptions.builder();
        private String mongoUri;
        private String username;
        private String password;
        private String[] addresses;
        private String dbName;
        private String authDbName;
        private int writeTimeout;
        private Boolean enableSSL;
        private Boolean sslInvalidHostNameAllowed;
        private String trustStorePath;
        private String trustStorePassword;
        private String trustStoreType;
        private String keyStorePath;
        private String keyStorePassword;
        private String keyStoreType;

        public MongoConnector build() throws SchedulerConfigException {
            this.connect();
            return this.connector;
        }

        public MongoConnectorBuilder withClient(MongoClient mongo) {
            this.connector.mongo = mongo;
            return this;
        }

        public MongoConnectorBuilder withUri(String mongoUri) {
            this.mongoUri = mongoUri;
            return this;
        }

        public MongoConnectorBuilder withCredentials(String username, String password) {
            this.username = username;
            this.password = password;
            return this;
        }

        public MongoConnectorBuilder withAddresses(String[] addresses) {
            this.addresses = addresses;
            return this;
        }

        private void connect() throws SchedulerConfigException {
            if (this.connector.mongo == null) {
                this.initializeMongo();
            } else if (this.mongoUri != null || this.username != null || this.password != null || this.addresses != null) {
                throw new SchedulerConfigException("Configure either a Mongo instance or MongoDB connection parameters.");
            }
        }

        private void initializeMongo() throws SchedulerConfigException {
            this.connector.mongo = this.connectToMongoDB();
            if (this.connector.mongo == null) {
                throw new SchedulerConfigException("Could not connect to MongoDB! Please check that quartz-mongodb configuration is correct.");
            }
            this.setWriteConcern();
        }

        private MongoClient connectToMongoDB() throws SchedulerConfigException {
            if (this.mongoUri == null && (this.addresses == null || this.addresses.length == 0)) {
                throw new SchedulerConfigException("At least one MongoDB address or a MongoDB URI must be specified .");
            }
            MongoClientOptions.Builder optionBuilder = this.createOptionBuilder();
            if (this.mongoUri != null) {
                return this.connectToMongoDB(this.mongoUri, optionBuilder);
            }
            return this.createClient(optionBuilder.build());
        }

        private MongoClient createClient(MongoClientOptions options) throws SchedulerConfigException {
            List<MongoCredential> credentials = this.createCredentials();
            List<ServerAddress> serverAddresses = this.collectServerAddresses();
            try {
                return new MongoClient(serverAddresses, credentials, options);
            }
            catch (MongoException e) {
                throw new SchedulerConfigException("Could not connect to MongoDB", (Throwable)e);
            }
        }

        private MongoClientOptions.Builder createOptionBuilder() throws SchedulerConfigException {
            SSLContext sslContext = this.getSSLContext();
            if (sslContext == null) {
                if (this.enableSSL != null) {
                    this.optionsBuilder.sslEnabled(this.enableSSL.booleanValue());
                    if (this.sslInvalidHostNameAllowed != null) {
                        this.optionsBuilder.sslInvalidHostNameAllowed(this.sslInvalidHostNameAllowed.booleanValue());
                    }
                }
            } else {
                this.optionsBuilder.sslEnabled(true);
                if (this.sslInvalidHostNameAllowed != null) {
                    this.optionsBuilder.sslInvalidHostNameAllowed(this.sslInvalidHostNameAllowed.booleanValue());
                }
                this.optionsBuilder.sslContext(sslContext);
            }
            return this.optionsBuilder;
        }

        private SSLContext getSSLContext() throws SchedulerConfigException {
            try {
                KeyStore trustStore = this.loadKeyStore(this.trustStorePath, this.trustStorePassword, this.trustStoreType);
                KeyStore keyStore = this.loadKeyStore(this.keyStorePath, this.keyStorePassword, this.keyStoreType);
                if (trustStore == null && keyStore == null) {
                    return null;
                }
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (trustStore != null) {
                    sslContextBuilder.loadTrustMaterial(trustStore, null);
                }
                if (keyStore != null) {
                    sslContextBuilder.loadKeyMaterial(keyStore, StringUtils.isBlank((CharSequence)this.keyStorePassword) ? null : this.keyStorePassword.toCharArray());
                }
                return sslContextBuilder.build();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new SchedulerConfigException("Cannot setup SSL context", (Throwable)e);
            }
        }

        private KeyStore loadKeyStore(String path, String password, String type) throws GeneralSecurityException, IOException {
            if (StringUtils.isBlank((CharSequence)path)) {
                return null;
            }
            KeyStore keyStore = KeyStore.getInstance((String)StringUtils.defaultIfBlank((CharSequence)type, (CharSequence)KeyStore.getDefaultType()));
            char[] passwordChars = StringUtils.isBlank((CharSequence)password) ? null : password.toCharArray();
            try (InputStream is = Files.newInputStream(Paths.get(path, new String[0]), new OpenOption[0]);){
                keyStore.load(is, passwordChars);
            }
            return keyStore;
        }

        private List<MongoCredential> createCredentials() {
            ArrayList<MongoCredential> credentials = new ArrayList<MongoCredential>(1);
            if (this.username != null) {
                if (this.authDbName != null) {
                    credentials.add(MongoCredential.createCredential((String)this.username, (String)this.authDbName, (char[])this.password.toCharArray()));
                } else {
                    credentials.add(MongoCredential.createCredential((String)this.username, (String)this.dbName, (char[])this.password.toCharArray()));
                }
            }
            return credentials;
        }

        private List<ServerAddress> collectServerAddresses() {
            ArrayList<ServerAddress> serverAddresses = new ArrayList<ServerAddress>();
            for (String a : this.addresses) {
                serverAddresses.add(new ServerAddress(a));
            }
            return serverAddresses;
        }

        private MongoClient connectToMongoDB(String mongoUriAsString, MongoClientOptions.Builder optionBuilder) throws SchedulerConfigException {
            try {
                return new MongoClient(new MongoClientURI(mongoUriAsString, optionBuilder));
            }
            catch (MongoException e) {
                throw new SchedulerConfigException("MongoDB driver thrown an exception", (Throwable)e);
            }
        }

        private void setWriteConcern() {
            WriteConcern writeConcern = WriteConcern.MAJORITY.withWTimeout((long)this.writeTimeout, TimeUnit.MILLISECONDS).withJournal(Boolean.valueOf(true));
            this.connector.mongo.setWriteConcern(writeConcern);
        }

        public MongoConnectorBuilder withAuthDatabaseName(String authDbName) {
            this.authDbName = authDbName;
            return this;
        }

        public MongoConnectorBuilder withDatabaseName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public MongoConnectorBuilder withMaxConnectionsPerHost(Integer maxConnectionsPerHost) {
            if (maxConnectionsPerHost != null) {
                this.optionsBuilder.connectionsPerHost(maxConnectionsPerHost.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withConnectTimeoutMillis(Integer connectTimeoutMillis) {
            if (connectTimeoutMillis != null) {
                this.optionsBuilder.connectTimeout(connectTimeoutMillis.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withSocketTimeoutMillis(Integer socketTimeoutMillis) {
            if (socketTimeoutMillis != null) {
                this.optionsBuilder.socketTimeout(socketTimeoutMillis.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withSocketKeepAlive(Boolean socketKeepAlive) {
            if (socketKeepAlive != null) {
                this.optionsBuilder.socketKeepAlive(socketKeepAlive.booleanValue());
            }
            return this;
        }

        public MongoConnectorBuilder withMaxConnectionIdleTime(Integer maxConnectionIdleTime) {
            if (maxConnectionIdleTime != null) {
                this.optionsBuilder.maxConnectionIdleTime(maxConnectionIdleTime.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withThreadsAllowedToBlockForConnectionMultiplier(Integer threadsAllowedToBlockForConnectionMultiplier) {
            if (threadsAllowedToBlockForConnectionMultiplier != null) {
                this.optionsBuilder.threadsAllowedToBlockForConnectionMultiplier(threadsAllowedToBlockForConnectionMultiplier.intValue());
            }
            return this;
        }

        public MongoConnectorBuilder withSSL(Boolean enableSSL, Boolean sslInvalidHostNameAllowed) {
            this.enableSSL = enableSSL;
            this.sslInvalidHostNameAllowed = sslInvalidHostNameAllowed;
            return this;
        }

        public MongoConnectorBuilder withTrustStore(String trustStorePath, String trustStorePassword, String trustStoreType) {
            this.trustStorePath = trustStorePath;
            this.trustStorePassword = trustStorePassword;
            this.trustStoreType = trustStoreType;
            return this;
        }

        public MongoConnectorBuilder withKeyStore(String keyStorePath, String keyStorePassword, String keyStoreType) {
            this.keyStorePath = keyStorePath;
            this.keyStorePassword = keyStorePassword;
            this.keyStoreType = keyStoreType;
            return this;
        }

        public MongoConnectorBuilder withWriteTimeout(int writeTimeout) {
            this.writeTimeout = writeTimeout;
            return this;
        }
    }
}

