/*
 * Decompiled with CFR 0.152.
 */
package com.novemberain.quartz.mongodb.util;

import com.novemberain.quartz.mongodb.cluster.Scheduler;
import com.novemberain.quartz.mongodb.dao.SchedulerDao;
import com.novemberain.quartz.mongodb.util.Clock;
import java.util.Date;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpiryCalculator {
    private static final Logger log = LoggerFactory.getLogger(ExpiryCalculator.class);
    private final SchedulerDao schedulerDao;
    private final Clock clock;
    private final long jobTimeoutMillis;
    private final long triggerTimeoutMillis;

    public ExpiryCalculator(SchedulerDao schedulerDao, Clock clock, long jobTimeoutMillis, long triggerTimeoutMillis) {
        this.schedulerDao = schedulerDao;
        this.clock = clock;
        this.jobTimeoutMillis = jobTimeoutMillis;
        this.triggerTimeoutMillis = triggerTimeoutMillis;
    }

    public boolean isJobLockExpired(Document lock) {
        return this.isLockExpired(lock, this.jobTimeoutMillis);
    }

    public boolean isTriggerLockExpired(Document lock) {
        String schedulerId = lock.getString((Object)"instanceId");
        return this.isLockExpired(lock, this.triggerTimeoutMillis) && this.hasDefunctScheduler(schedulerId);
    }

    private boolean hasDefunctScheduler(String schedulerId) {
        Scheduler scheduler = this.schedulerDao.findInstance(schedulerId);
        if (scheduler == null) {
            log.debug("No such scheduler: {}", (Object)schedulerId);
            return false;
        }
        return scheduler.isDefunct(this.clock.millis()) && this.schedulerDao.isNotSelf(scheduler);
    }

    private boolean isLockExpired(Document lock, long timeoutMillis) {
        Date lockTime = lock.getDate((Object)"time");
        long elapsedTime = this.clock.millis() - lockTime.getTime();
        return elapsedTime > timeoutMillis;
    }
}

