/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.runtime.api.Framework;

public class MsOfficeUrlFilter
implements Filter {
    private static final Logger log = LogManager.getLogger(MsOfficeUrlFilter.class);
    private static final String CONTEXT_PATH_PROPERTY = "org.nuxeo.ecm.contextPath";
    private static final String CUSTOM_WEBUI_CONTEXT_PATH_PROPERTY = "msofficeurlfixer.webui.contextPath";
    private Map<String, String> urlFragmentPatterns = new HashMap<String, String>();
    private List<String> webUiUrlFragmentPatterns = Stream.of("ui").collect(Collectors.toList());

    public void init(FilterConfig fConfig) throws ServletException {
        log.debug("MsOfficeUrlFilter initialization");
        if (this.urlFragmentPatterns.isEmpty()) {
            String contextRoot = Framework.getProperty((String)CONTEXT_PATH_PROPERTY);
            String webuiContextRoot = Framework.getProperty((String)CUSTOM_WEBUI_CONTEXT_PATH_PROPERTY);
            if (webuiContextRoot != null) {
                for (String uiPattern : Arrays.stream(webuiContextRoot.split(",")).map(String::trim).collect(Collectors.toList())) {
                    log.debug("<init> UI url: {}", (Object)uiPattern);
                    this.webUiUrlFragmentPatterns.add(uiPattern);
                }
            }
            for (String uiPattern : this.webUiUrlFragmentPatterns) {
                String replacementFragment = String.format("%s/%s/#!", contextRoot, uiPattern);
                this.urlFragmentPatterns.put(String.format("%s/%s/%%23!", contextRoot, uiPattern), replacementFragment);
                this.urlFragmentPatterns.put(String.format("%s/%s/#%%21", contextRoot, uiPattern), replacementFragment);
                this.urlFragmentPatterns.put(String.format("%s/%s/%%23%%21", contextRoot, uiPattern), replacementFragment);
            }
        }
    }

    public void destroy() {
        log.debug("MsOfficeUrlFilter destroy");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (request instanceof HttpServletRequest) {
            HttpServletRequest req = (HttpServletRequest)request;
            String url = req.getRequestURL().toString();
            for (Map.Entry<String, String> entry : this.urlFragmentPatterns.entrySet()) {
                String pattern = entry.getKey();
                String replacement = entry.getValue();
                log.debug("<doFilter> {} == {} == {}", (Object)url, (Object)pattern, (Object)replacement);
                if (url.indexOf(pattern) == -1) continue;
                String newUrl = url.replaceFirst(pattern, replacement);
                log.debug("<doFilter> Redirection to {}", (Object)newUrl);
                HttpServletResponse httpResponse = (HttpServletResponse)response;
                httpResponse.sendRedirect(newUrl);
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

