/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo._3d.viewer.adapter;

import com.nuxeo._3d.viewer.adapter.NX3DBlobContent;
import com.nuxeo._3d.viewer.adapter.NX3DBlobContentAdapter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.nuxeo.ecm.core.api.DocumentModel;

public class NX3DBlobContentAdapterImpl
implements NX3DBlobContentAdapter {
    protected final DocumentModel doc;

    public NX3DBlobContentAdapterImpl(DocumentModel doc) {
        this.doc = doc;
    }

    @Override
    public void clear() {
        this.doc.setPropertyValue("nx3d:renditions", null);
        this.doc.setPropertyValue("nx3d:views", null);
    }

    @Override
    public List<NX3DBlobContent> getBlobContents() {
        List<Map<String, Serializable>> blobContents = this.getStoredBlobContentProps();
        return blobContents.stream().map(NX3DBlobContent::new).collect(Collectors.toList());
    }

    @Override
    public NX3DBlobContent getBlobContent(String blobContentName) {
        List<Map<String, Serializable>> blobContents = this.getStoredBlobContentProps();
        Optional<NX3DBlobContent> result = blobContents.stream().map(NX3DBlobContent::new).filter(entry -> entry.name != null && entry.name.equals(blobContentName)).findFirst();
        return result.orElse(null);
    }

    @Override
    public void addBlobContentProp(NX3DBlobContent blobContent) {
        List<NX3DBlobContent> blobContents = this.getBlobContents();
        blobContents = blobContents.stream().filter(item -> !blobContent.getName().equals(item.getName())).collect(Collectors.toList());
        blobContents.add(blobContent);
        this.saveBlobContents(blobContents);
    }

    @Override
    public void removeBlobContentProp(String blobContentName) {
        List<NX3DBlobContent> blobContents = this.getBlobContents();
        List<NX3DBlobContent> filteredBlobContents = blobContents.stream().filter(blobContent -> !blobContentName.equals(blobContent.getName())).collect(Collectors.toList());
        if (blobContents.size() != filteredBlobContents.size()) {
            this.saveBlobContents(filteredBlobContents);
        }
    }

    @Override
    public List<Map<String, Serializable>> getStoredBlobContentProps() {
        return null;
    }

    @Override
    public DocumentModel saveBlobContents(List<NX3DBlobContent> blobContents) {
        return this.doc;
    }
}

