/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo._3d.viewer.listener;

import com.nuxeo._3d.viewer.adapter.NX3DBlobContentAdapter;
import com.nuxeo._3d.viewer.adapter.NX3DBlobContentAdapterImpl;
import com.nuxeo._3d.viewer.service.GLBConversionService;
import com.nuxeo._3d.viewer.stream.worker.Erase3DAnnotationsWork;
import com.nuxeo._3d.viewer.stream.worker.GLBConversionWork;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.comment.api.AnnotationService;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.api.Framework;

public class NX3DChangedListener
implements EventListener {
    private static final Logger log = LogManager.getLogger(NX3DChangedListener.class);
    public static final String DISABLE_GLB_CONVERSIONS_GENERATION_LISTENER = "disableGLBConversionsGenerationListener";

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        log.debug("Entered NX3DChangedListener for document: {}", (Object)doc.getId());
        if (Boolean.TRUE.equals(ctx.getProperty(DISABLE_GLB_CONVERSIONS_GENERATION_LISTENER))) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((DocumentModel)doc).getId();
            log.trace("GLB conversions are disabled for document {}", supplierArray);
            return;
        }
        String eventName = event.getName();
        if (this.shouldProcess(doc, eventName)) {
            if ("beforeDocumentModification".equals(eventName)) {
                this.resetProperties(doc);
            }
            if (doc.getPropertyValue("file:content") != null) {
                this.scheduleAsyncProcessing(doc);
            }
        }
        log.debug("Completed NX3DChangedListener for document: {}", (Object)doc.getId());
    }

    protected boolean shouldProcess(DocumentModel doc, String eventName) {
        return doc.hasFacet("NX3D") && !doc.isProxy() && ("documentCreated".equals(eventName) || doc.getProperty("file:content").isDirty()) && (((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob() == null ? "beforeDocumentModification".equals(eventName) && doc.getProperty("file:content").isRemoved() : this.isSupported(doc) != false);
    }

    protected Boolean isSupported(DocumentModel document) {
        GLBConversionService glbConversionService = (GLBConversionService)Framework.getService(GLBConversionService.class);
        ArrayList<String> supportedMimeTypes = new ArrayList<String>(Arrays.stream(glbConversionService.runScript("javascript.GetSupportedMimeTypesOperation", document).toString().split(",")).filter(s -> !s.equals("")).toList());
        supportedMimeTypes.addAll(Arrays.stream(Framework.getProperties().getProperty("nuxeo-3d-viewer.extended.supported.mimetypes", "").split(",")).filter(s -> !s.equals("")).toList());
        return supportedMimeTypes.contains(((MimetypeRegistry)Framework.getService(MimetypeRegistry.class)).getMimetypeFromFilename(((BlobHolder)document.getAdapter(BlobHolder.class)).getBlob().getFilename()));
    }

    protected void resetProperties(DocumentModel doc) {
        log.debug("Resetting GLB info of document {}", (Object)doc);
        NX3DBlobContentAdapter adapter = (NX3DBlobContentAdapter)doc.getAdapter(NX3DBlobContentAdapterImpl.class);
        adapter.clear();
        this.clearAllAnnotations(doc);
    }

    protected void scheduleAsyncProcessing(DocumentModel doc) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        GLBConversionWork work = new GLBConversionWork(doc.getRepositoryName(), doc.getId());
        log.debug("Scheduling work: glb conversion of document {}.", (Object)doc);
        workManager.schedule((Work)work, true);
    }

    protected void clearAllAnnotations(DocumentModel doc) {
        AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
        List annotations = annotationService.getAnnotations(doc.getCoreSession(), doc.getId(), "file:content");
        if (!annotations.isEmpty()) {
            WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
            Erase3DAnnotationsWork work = new Erase3DAnnotationsWork(doc.getRepositoryName(), doc.getId());
            log.debug("Scheduling work: Erase 3D Annotations of document {}.", (Object)doc);
            workManager.schedule((Work)work, true);
        }
    }
}

