/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo._3d.viewer.service;

import com.nuxeo._3d.viewer.service.GLBConversionService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.platform.commandline.executor.api.CmdParameters;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandLineExecutorService;
import org.nuxeo.ecm.platform.commandline.executor.api.CommandNotAvailable;
import org.nuxeo.ecm.platform.commandline.executor.api.ExecResult;
import org.nuxeo.io.fsexporter.FSExporterService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class GLBConversionServiceImpl
extends DefaultComponent
implements GLBConversionService {
    @Override
    public Blob convert(DocumentModel document, String targetBlobName) {
        return (Blob)this.runScript(this.getGLBConverter(((BlobHolder)document.getAdapter(BlobHolder.class)).getBlob().getMimeType()), document);
    }

    private String getGLBConverter(String fromMimeType) {
        if ("model/obj".equals(fromMimeType)) {
            return "NX3D.ConvertOBJToGLB";
        }
        return "NX3D.ConvertCUSTOMToGLB";
    }

    @Override
    public Object runScript(String scriptId, DocumentModel doc) {
        Object object;
        AutomationService automationService = (AutomationService)Framework.getService(AutomationService.class);
        OperationContext ctx = new OperationContext(doc.getCoreSession());
        try {
            ctx.setInput((Object)doc);
            Object result = automationService.run(ctx, scriptId);
            if (result == null) {
                throw new OperationException("The operation returned null");
            }
            object = result;
        }
        catch (Throwable result) {
            try {
                try {
                    ctx.close();
                }
                catch (Throwable throwable) {
                    result.addSuppressed(throwable);
                }
                throw result;
            }
            catch (OperationException e) {
                String message = String.format("Error while running script: %s for input: %s", scriptId, doc);
                throw new NuxeoException(message, (Throwable)e);
            }
        }
        ctx.close();
        return object;
    }

    @Override
    public Blob convertFromCustom(DocumentModel doc, String targetBlobName) {
        String converterName;
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        SimpleBlobHolder input = new SimpleBlobHolder(blob);
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        CommandLineExecutorService ces = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", targetBlobName);
        try {
            converterName = new MimeType(blob.getMimeType()).getSubType().toLowerCase() + "2glb";
        }
        catch (MimeTypeParseException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (ces.getCommandAvailability(converterName).isAvailable() && cs.isConverterAvailable(converterName).isAvailable()) {
            BlobHolder output = cs.convert(converterName, (BlobHolder)input, params);
            return output.getBlob();
        }
        throw new NuxeoException(String.format("Custom GLB Converter for Mimetype: %s is not available", blob.getMimeType()));
    }

    @Override
    public Blob convertFromObj(DocumentModel document, String targetBlobName) {
        try {
            return document.isFolder() ? this.convertFolderish(document, "obj", targetBlobName) : this.convertSingleDocument(document, "obj", targetBlobName);
        }
        catch (IOException | CommandNotAvailable e) {
            throw new NuxeoException(e);
        }
    }

    @Override
    public Blob convertFromObj(DocumentModel document) {
        return this.convertFromObj(document, "");
    }

    public Blob convertFolderish(DocumentModel doc, String inputFormat, String targetBlobName) throws IOException, CommandNotAvailable {
        File glbFile;
        Path tmpFolder = Framework.createTempDirectory((String)(inputFormat + "_conversion"), (FileAttribute[])new FileAttribute[0]);
        FSExporterService fsExporter = (FSExporterService)Framework.getService(FSExporterService.class);
        fsExporter.export(doc.getCoreSession(), doc.getPathAsString(), tmpFolder.toString(), null);
        File[] tmpFolderFiles = tmpFolder.toFile().listFiles();
        if (tmpFolderFiles == null || tmpFolderFiles.length != 1 || !tmpFolderFiles[0].isDirectory()) {
            throw new NuxeoException("unknown exported folderish structure");
        }
        Path tmpDocFolder = tmpFolderFiles[0].toPath();
        Optional<File> inputFile = Arrays.stream(tmpDocFolder.toFile().listFiles()).filter(file -> FilenameUtils.isExtension((String)file.getName(), (String)inputFormat)).findFirst();
        if (inputFile.isEmpty()) {
            throw new NuxeoException("No " + inputFormat + " file found in structure");
        }
        CommandLineExecutorService cs = (CommandLineExecutorService)Framework.getService(CommandLineExecutorService.class);
        CmdParameters parameters = new CmdParameters();
        parameters.addNamedParameter("sourceFilePath", inputFile.get().getAbsolutePath());
        if (StringUtils.isBlank((CharSequence)targetBlobName)) {
            targetBlobName = StringUtils.substring((String)inputFile.get().getName(), (int)0, (int)inputFile.get().getName().indexOf("." + inputFormat));
        }
        if (((String)targetBlobName).toLowerCase().indexOf(".glb") < 0) {
            targetBlobName = (String)targetBlobName + ".glb";
        }
        String targetPath = tmpFolder.toFile().getAbsolutePath() + "/" + (String)targetBlobName;
        parameters.addNamedParameter("targetFilePath", targetPath);
        ExecResult result = cs.execCommand("obj2gltf", parameters);
        if (result.isSuccessful() && (glbFile = new File(targetPath)).exists()) {
            return new FileBlob(new File(targetPath), "model/gltf-binary");
        }
        throw new NuxeoException("OBJ to GLB conversion failed");
    }

    public Blob convertSingleDocument(DocumentModel doc, String inputFormat, String targetBlobName) {
        Blob blob = (Blob)doc.getPropertyValue("file:content");
        SimpleBlobHolder input = new SimpleBlobHolder(blob);
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (StringUtils.isBlank((CharSequence)targetBlobName)) {
            targetBlobName = StringUtils.substring((String)blob.getFilename(), (int)0, (int)blob.getFilename().indexOf("." + inputFormat));
        }
        if (((String)targetBlobName).toLowerCase().indexOf(".glb") < 0) {
            targetBlobName = (String)targetBlobName + ".glb";
        }
        params.put("targetFileName", targetBlobName);
        String converterName = "obj2gltf";
        BlobHolder output = cs.convert(converterName, (BlobHolder)input, params);
        return output.getBlob();
    }
}

