/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo._3d.viewer.stream.worker;

import java.io.Serializable;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.platform.comment.api.AnnotationService;
import org.nuxeo.runtime.api.Framework;

public class Erase3DAnnotationsWork
extends AbstractWork {
    public static final String CATEGORY = "erase3DAnnotations";
    private static final Logger log = LogManager.getLogger(Erase3DAnnotationsWork.class);

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":erase3DAnnotations:";
    }

    public Erase3DAnnotationsWork(String repositoryName, String docId) {
        super(Erase3DAnnotationsWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        if (doc.hasFacet("NX3D")) {
            log.debug("Started Erase3DAnnotationsWork for doc: {}", (Object)doc);
            AnnotationService annotationService = (AnnotationService)Framework.getService(AnnotationService.class);
            List annotations = annotationService.getAnnotations(this.session, doc.getId(), "file:content");
            annotations.forEach(annotation -> annotationService.deleteAnnotation(doc.getCoreSession(), annotation.getId()));
            this.doSaveAndCommit(doc, true);
            this.setStatus("Done");
            log.debug("Completed Erase3DAnnotationsWork for doc: {}", (Object)doc);
        }
    }

    public int getRetryCount() {
        return 2;
    }

    public String getTitle() {
        return "Erase 3D Annotations: " + this.getId();
    }

    protected void doSaveAndCommit(DocumentModel doc, boolean doCommit) {
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        doc.putContextData("disableGLBConversionsGenerationListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
        this.session.saveDocument(doc);
        if (doCommit) {
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
    }
}

