/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo._3d.viewer.converter;

import java.io.IOException;
import java.io.Serializable;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FilenameUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.platform.convert.plugins.CommandLineConverter;
import org.nuxeo.runtime.api.Framework;

public class GLTFToGLBConverter
extends CommandLineConverter {
    public BlobHolder convert(BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        Blob blob = blobHolder.getBlob();
        FileBlob gltfBlob = null;
        try {
            Path tmpDirectory = Framework.createTempDirectory((String)"conversion-glb", (FileAttribute[])new FileAttribute[0]);
            try (ZipInputStream zipIn = new ZipInputStream(blob.getStream());){
                ZipEntry ze;
                while ((ze = zipIn.getNextEntry()) != null) {
                    Path resolvedPath = tmpDirectory.resolve(ze.getName()).normalize();
                    if (!resolvedPath.startsWith(tmpDirectory)) {
                        throw new RuntimeException("Entry with an illegal path: " + ze.getName());
                    }
                    if (ze.isDirectory()) {
                        Files.createDirectories(resolvedPath, new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(resolvedPath.getParent(), new FileAttribute[0]);
                    Files.copy(zipIn, resolvedPath, new CopyOption[0]);
                    if (!FilenameUtils.isExtension((String)resolvedPath.getFileName().toString(), (String)"gltf")) continue;
                    gltfBlob = new FileBlob(resolvedPath.toFile(), "model/gltf");
                }
            }
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
        if (gltfBlob != null) {
            return super.convert((BlobHolder)new SimpleBlobHolder(gltfBlob), parameters);
        }
        throw new NuxeoException("couldn't find gltf file");
    }
}

