/*
 * Decompiled with CFR 0.152.
 */
package com.nuxeo._3d.viewer.stream.worker;

import com.nuxeo._3d.viewer.adapter.NX3DBlobContent;
import com.nuxeo._3d.viewer.adapter.NX3DBlobContentAdapter;
import com.nuxeo._3d.viewer.adapter.NX3DRenditionBlobContentAdapter;
import com.nuxeo._3d.viewer.service.GLBConversionService;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class GLBConversionWork
extends AbstractWork {
    public static final String GLB_CONVERSION_DONE_EVENT = "GLBConversionDone";
    private static final Logger log = LogManager.getLogger(GLBConversionWork.class);
    public static final String OPTIMIZED_RENDITION_NAME = "optimized";
    public static final String THUMBNAIL_RENDITION_NAME = "thumbnail";
    public static final String CONVERTED_GLB_RENDITION_NAME = "convertedGLB";
    public static final String CATEGORY = "glbConversion";
    public static final String BASELINE_ENVIRONMENT = "environment-image=neutral&shadow-intensity=0&shadow-softness=0&exposure=0.92&min-camera-orbit=-Infinity 0deg auto&max-camera-orbit=Infinity 180deg auto";

    protected static String computeIdPrefix(String repositoryName, String docId) {
        return repositoryName + ":" + docId + ":glbconversion:";
    }

    public GLBConversionWork(String repositoryName, String docId) {
        super(GLBConversionWork.computeIdPrefix(repositoryName, docId));
        this.setDocument(repositoryName, docId);
    }

    public String getCategory() {
        return CATEGORY;
    }

    public void work() {
        this.setProgress(Work.Progress.PROGRESS_INDETERMINATE);
        this.openSystemSession();
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        log.debug("Starting GLBConversionWork for doc {}", (Object)doc);
        BlobHolder blobHolder = (BlobHolder)doc.getAdapter(BlobHolder.class);
        Blob blob = blobHolder.getBlob();
        if (!"model/gltf-binary".equals(blob.getMimeType())) {
            log.debug("Generating convertedGLB for doc {}", (Object)doc);
            this.newTransaction();
            GLBConversionService glbConversionService = (GLBConversionService)Framework.getService(GLBConversionService.class);
            blob = glbConversionService.convert(doc, blob.getFilename());
            NX3DBlobContentAdapter renditionBlobContentAdapter = (NX3DBlobContentAdapter)doc.getAdapter(NX3DRenditionBlobContentAdapter.class);
            renditionBlobContentAdapter.addBlobContentProp(new NX3DBlobContent(CONVERTED_GLB_RENDITION_NAME, blob));
            this.doSaveAndCommit(doc, true);
        }
        this.setStatus("Updating previews");
        this.computePreviews(doc, blob);
        this.doSaveAndCommit(doc, false);
        this.setStatus("Done");
        this.fireGLBConversionDoneEvent();
        log.debug("Completed GLBConversionWork for doc {}", (Object)doc);
    }

    public int getRetryCount() {
        return 2;
    }

    public String getTitle() {
        return "GLB Conversions: " + this.getId();
    }

    protected void computePreviews(DocumentModel doc, Blob blob) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", blob.getFilename());
        String fileName = FilenameUtils.getBaseName((String)blob.getFilename());
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        this.newTransaction();
        log.debug("Generating Rendition: optimized for doc {}", (Object)doc);
        BlobHolder optimizationResult = cs.convert("glbOptimizer", (BlobHolder)new SimpleBlobHolder(blob), params);
        Blob optimizedBlob = optimizationResult.getBlob();
        optimizedBlob.setFilename(this.getFileName(StringUtils.capitalize((String)OPTIMIZED_RENDITION_NAME), fileName, "glb"));
        NX3DBlobContentAdapter renditionBlobContentAdapter = (NX3DBlobContentAdapter)doc.getAdapter(NX3DRenditionBlobContentAdapter.class);
        renditionBlobContentAdapter.addBlobContentProp(new NX3DBlobContent(OPTIMIZED_RENDITION_NAME, optimizedBlob));
        this.doSaveAndCommit(doc, true);
        this.newTransaction();
    }

    protected void fireGLBConversionDoneEvent() {
        DocumentModel doc = this.session.getDocument((DocumentRef)new IdRef(this.docId));
        DocumentEventContext ctx = new DocumentEventContext(this.session, this.session.getPrincipal(), doc);
        Event event = ctx.newEvent(GLB_CONVERSION_DONE_EVENT);
        ((EventService)Framework.getService(EventService.class)).fireEvent(event);
    }

    protected Blob doScreenshot(Blob glbBlob, String width, String height, String environment, String outFilename) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("targetFileName", outFilename);
        params.put("height", height);
        params.put("width", width);
        params.put("environment", environment);
        ConversionService cs = (ConversionService)Framework.getService(ConversionService.class);
        BlobHolder result = cs.convert("glb2png", (BlobHolder)new SimpleBlobHolder(glbBlob), params);
        if (result.getBlob() != null) {
            result.getBlob().setFilename(outFilename);
        }
        return result.getBlob();
    }

    protected void doSaveAndCommit(DocumentModel doc, boolean doCommit) {
        log.debug("Completed generating convertedGLB for doc {}", (Object)doc);
        if (doc.isVersion()) {
            doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        doc.putContextData("disableGLBConversionsGenerationListener", (Serializable)Boolean.TRUE);
        doc.putContextData("disableNotificationService", (Serializable)Boolean.TRUE);
        doc.putContextData("disableAuditLogger", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutoCheckOut", (Serializable)Boolean.TRUE);
        doc.putContextData("DisableAutomaticVersioning", (Serializable)Boolean.TRUE);
        this.session.saveDocument(doc);
        log.debug("doSaveAndCommit -> document saved : doc {}", (Object)doc);
        if (doCommit) {
            this.commitOrRollbackTransaction();
            this.startTransaction();
            log.debug("doSaveAndCommit -> Committed changes for doc {}", (Object)doc);
        }
    }

    private String getFileName(String prefix, String fileName, String extension) {
        return String.format("%s_%s.%s", prefix, fileName, extension);
    }

    private void newTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        TransactionHelper.startTransaction((int)this.getTransactionTimeout());
    }

    private Integer getTransactionTimeout() {
        return Integer.parseInt(Framework.getProperty((String)"nuxeo.3d.viewer.glb.conversion.timeout", (String)"300"));
    }
}

