<h1>Nuxeo 3D Viewer</h1>
<hr />

A plugin that adds 3D model preview and annotation capabilities to the nuxeo platform.
Currently supported 3D Model formats are GLB and OBJ.

# List of Features
- An event listener, worker and cli based converter to generate GLB files optimized for web preview using [gltf-transform](https://gltf-transform.donmccurdy.com/cli.html)
- A webui element to view 3D model files that leverages [model-viewer](https://modelviewer.dev/)
- A 3D model annotation webui component which also leverages [model-viewer](https://modelviewer.dev/)
- A bulk action to recompute previews of multiple documents using a query
- OBJ to GLB conversion using [obj2gltf](https://github.com/CesiumGS/obj2gltf) to be used by web ui preview component
- An automation operation to convert a single document holding a simple OBJ file or a folder containing the OBJ file and other resources as individual documents


## Webui
Below is an example of how to use the viewer in a document view layout

```html
<nuxeo-3d-viewer-model-preview document="[[document]]"></nuxeo-3d-viewer-model-preview>
<nuxeo-3d-viewer-renditions document="[[document]]"></nuxeo-3d-viewer-renditions>
```

Below is an example of how to use the annotation web component in a tab

```html
<nuxeo-3d-viewer-annotation document="[[document]]"></nuxeo-3d-viewer-annotation>
```

A complete example is available [here](https://github.com/nuxeo/nuxeo-3d-viewer/tree/lts-2023/nuxeo-3d-viewer-web)

## Bulk recompute command

```bash
curl --location 'https://myserver/nuxeo/site/api/v1/automation/Bulk.RunAction' \
--header 'Accept: application/json, application/json+nxentity' \
--header 'Content-Type: application/json+nxrequest' \
--header 'Authorization: Basic ...' \
--data '{
    "params": {
        "action": "recomputeGlbPreview",
        "query": "Select * From Document Where ecm:mixinType = '\''NX3D'\''",
        "parameters": "{\"xpath\": \"file:content\"}"
    }
}'
```

# Dev Environment setup

As the plugin depends on several CLI tools, even when building the solution, for the unit test
cases to run successfully, we need the environment to be equipped with them.

Run the below command to install the necessary tools:
```
npm install -g @gltf-transform/cli gltf-pipeline obj2gltf
```

# Build

Assuming maven is correctly setup on your computer:

```
git clone https://github.com/nuxeo/nuxeo-3d-viewer
cd nuxeo-3d-viewer
mvn clean install
```

# Install
Install the package on your instance.

This plugin relies on [gltf-pipeline](https://github.com/CesiumGS/gltf-pipeline), [gltf-transform](https://gltf-transform.donmccurdy.com/cli.html) and [obj2gltf](https://github.com/CesiumGS/obj2gltf) which must be installed on your nuxeo server. Have a look at the repository [Dockerfile](https://github.com/nuxeo/nuxeo-3d-viewer/blob/task/hide-render-views-thumnails-functionality/ci/docker/Dockerfile) to find more details about the installation steps.

A sample document type - 3D Model is provided by default which can be used to upload the 3D Model files (GLB and OBJ)


# Marketplace
This plugin is published on the [Nuxeo marketplace](https://nos-preprod-connect.nuxeocloud.com/nuxeo/site/marketplace/package/nuxeo-3d-viewer)


# License
[Apache License, Version 2.0](http://www.apache.org/licenses/LICENSE-2.0.html)

# About Nuxeo
Nuxeo Platform is an open source Content Services platform, written in Java. Data can be stored in both SQL & NoSQL databases.

The development of the Nuxeo Platform is mostly done by Nuxeo employees with an open development model.

The source code, documentation, roadmap, issue tracker, testing, benchmarks are all public.

Typically, Nuxeo users build different types of information management solutions for [document management](https://www.nuxeo.com/solutions/document-management/), [case management](https://www.nuxeo.com/solutions/case-management/), and [digital asset management](https://www.nuxeo.com/solutions/dam-digital-asset-management/), use cases. It uses schema-flexible metadata & content models that allows content to be repurposed to fulfill future use cases.

More information is available at [www.nuxeo.com](https://www.nuxeo.com).


