/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.audit.advanced;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.runtime.api.Framework;

public class AdvancedDocumentAuditListener
implements EventListener {
    private static final Log log = LogFactory.getLog(AdvancedDocumentAuditListener.class);
    private static final List<String> SYSTEM_PROPS = Arrays.asList("dc:created", "dc:creator", "dc:modified", "dc:contributors");
    public static final String EVENT_ID = "Property Modification";
    public static final String FIELD_NAME = "fieldname";
    public static final String OLD_VALUE = "oldValue";
    public static final String NEW_VALUE = "newValue";
    public static final String EMPTY_VALUE = "EMPTY";

    public void handleEvent(Event event) {
        EventContext ectx = event.getContext();
        if (!(ectx instanceof DocumentEventContext)) {
            return;
        }
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger == null) {
            log.error((Object)"No AuditLogger implementation is available");
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ectx;
        DocumentModel newDoc = docCtx.getSourceDocument();
        DocumentModel oldDoc = newDoc.getCoreSession().getDocument(newDoc.getRef());
        Context context = new Context(newDoc, oldDoc, event, logger);
        this.processDocument(context);
    }

    protected void processDocument(Context context) {
        String[] schemas;
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (String schema : schemas = context.newDoc.getSchemas()) {
            Collection properties = context.newDoc.getPropertyObjects(schema);
            for (Property property : properties) {
                String fieldName = property.getName();
                if (SYSTEM_PROPS.contains(fieldName) || !property.isDirty()) continue;
                Property oldProperty = context.oldDoc.getProperty(fieldName);
                entries.addAll(this.processProperty(context, oldProperty, property));
            }
        }
        if (entries.size() > 0) {
            context.logger.addLogEntries(entries);
        }
    }

    protected List<LogEntry> processProperty(Context context, Property oldProperty, Property newProperty) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        if (oldProperty.isScalar()) {
            entries.add(this.processScalarProperty(context, oldProperty, newProperty));
        }
        if (oldProperty.isComplex() && !oldProperty.isList()) {
            if (oldProperty instanceof BlobProperty) {
                entries.add(this.processBlobProperty(context, oldProperty, newProperty));
            } else {
                entries.addAll(this.processComplexProperty(context, oldProperty, newProperty));
            }
        }
        if (oldProperty instanceof ArrayProperty) {
            entries.addAll(this.processScalarList(context, oldProperty.getPath(), oldProperty.getValue(), newProperty.getValue()));
        }
        return entries;
    }

    protected LogEntry processScalarProperty(Context context, Property oldProperty, Property newProperty) {
        return this.getEntry(context, oldProperty.getPath(), oldProperty.getValue(), newProperty.getValue());
    }

    protected List<LogEntry> processScalarList(Context context, String fieldName, Object oldValue, Object newValue) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        List<Serializable> oldList = null;
        if (oldValue != null) {
            oldList = Arrays.asList((Serializable[])oldValue);
        }
        List<Serializable> newList = Arrays.asList((Serializable[])newValue);
        fieldName = this.normalizeFieldName(fieldName);
        ArrayList<Serializable> added = new ArrayList<Serializable>(newList);
        if (oldList != null) {
            added.removeAll(oldList);
        }
        for (Serializable addedValue : added) {
            LogEntry entry = this.getEntry(context, fieldName, null, addedValue);
            entry.setComment(fieldName + " : Added " + this.formatPropertyValue(addedValue));
            entries.add(entry);
        }
        if (oldList != null) {
            ArrayList<Serializable> removed = new ArrayList<Serializable>(oldList);
            removed.removeAll(newList);
            for (Serializable removedValue : removed) {
                LogEntry entry = this.getEntry(context, fieldName, removedValue, null);
                entry.setComment(fieldName + " : Removed " + this.formatPropertyValue(removedValue));
                entries.add(entry);
            }
        }
        return entries;
    }

    protected List<LogEntry> processComplexProperty(Context context, Property oldProperty, Property newProperty) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        Iterator dirtyProperties = newProperty.getDirtyChildren();
        while (dirtyProperties.hasNext()) {
            Property dirtyProperty = (Property)dirtyProperties.next();
            entries.addAll(this.processProperty(context, oldProperty.get(dirtyProperty.getName()), dirtyProperty));
        }
        return entries;
    }

    protected LogEntry processBlobProperty(Context context, Property oldProperty, Property newProperty) {
        Blob oldBlob = (Blob)oldProperty.getValue();
        String oldFilename = oldBlob != null ? oldBlob.getFilename() : null;
        Blob newBlob = (Blob)newProperty.getValue();
        String newFilename = newBlob != null ? newBlob.getFilename() : null;
        return this.getEntry(context, oldProperty.getPath(), (Serializable)((Object)oldFilename), (Serializable)((Object)newFilename));
    }

    protected LogEntry getEntry(Context context, String fieldName, Serializable oldValue, Serializable newValue) {
        AuditLogger logger = context.logger;
        Event event = context.event;
        DocumentModel doc = context.newDoc;
        LogEntry entry = logger.newLogEntry();
        entry.setEventId(EVENT_ID);
        entry.setCategory("Document");
        entry.setEventDate(new Date(event.getTime()));
        entry.setDocUUID(doc.getRef());
        entry.setDocLifeCycle(doc.getCurrentLifeCycleState());
        entry.setPrincipalName(doc.getCoreSession().getPrincipal().getName());
        entry.setRepositoryId(doc.getRepositoryName());
        fieldName = this.normalizeFieldName(fieldName);
        HashMap<String, ExtendedInfo> extended = new HashMap<String, ExtendedInfo>();
        extended.put(FIELD_NAME, logger.newExtendedInfo((Serializable)((Object)fieldName)));
        String formatedOldValue = this.formatPropertyValue(oldValue);
        String formatedNewValue = this.formatPropertyValue(newValue);
        extended.put(OLD_VALUE, logger.newExtendedInfo((Serializable)((Object)formatedOldValue)));
        extended.put(NEW_VALUE, logger.newExtendedInfo((Serializable)((Object)formatedNewValue)));
        entry.setExtendedInfos(extended);
        entry.setComment(fieldName + " : " + formatedOldValue + " -> " + formatedNewValue);
        return entry;
    }

    protected String formatPropertyValue(Serializable value) {
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            String pattern = "MM/dd/yyyy";
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            return format.format(calendar.getTime());
        }
        if (value != null) {
            return value.toString();
        }
        return EMPTY_VALUE;
    }

    protected String normalizeFieldName(String fieldName) {
        if (fieldName.startsWith("/")) {
            return fieldName.substring(1);
        }
        return fieldName;
    }

    class Context {
        private DocumentModel newDoc;
        private DocumentModel oldDoc;
        private Event event;
        private AuditLogger logger;

        public Context(DocumentModel newDoc, DocumentModel oldDoc, Event event, AuditLogger logger) {
            this.newDoc = newDoc;
            this.oldDoc = oldDoc;
            this.event = event;
            this.logger = logger;
        }
    }
}

