/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.rendition.impl;

import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.platform.rendition.Rendition;
import org.nuxeo.ecm.platform.rendition.RenditionException;
import org.nuxeo.ecm.platform.rendition.impl.AbstractRendition;
import org.nuxeo.ecm.platform.rendition.service.RenditionDefinition;

public abstract class LazyRendition
extends AbstractRendition
implements Rendition {
    protected List<Blob> blobs = null;

    public LazyRendition(RenditionDefinition definition) {
        super(definition);
    }

    @Override
    public Blob getBlob() throws RenditionException {
        List<Blob> blobs = this.getBlobs();
        if (blobs != null && blobs.size() > 0) {
            return blobs.get(0);
        }
        return null;
    }

    @Override
    public List<Blob> getBlobs() throws RenditionException {
        if (this.blobs == null) {
            this.blobs = this.computeRenditionBlobs();
        }
        return this.blobs;
    }

    protected abstract List<Blob> computeRenditionBlobs() throws RenditionException;
}

