/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.impl.atompub;

import java.io.OutputStream;
import java.math.BigInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.chemistry.opencmis.commons.data.ExtensionsData;
import org.apache.chemistry.opencmis.commons.data.ObjectData;
import org.apache.chemistry.opencmis.commons.data.ObjectList;
import org.apache.chemistry.opencmis.commons.enums.RelationshipDirection;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.UrlBuilder;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.commons.server.ObjectInfo;
import org.apache.chemistry.opencmis.server.impl.atompub.AbstractAtomPubServiceCall;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomEntry;
import org.apache.chemistry.opencmis.server.impl.atompub.AtomFeed;

public class RelationshipService {

    public static class GetObjectRelationships
    extends AbstractAtomPubServiceCall {
        public void serve(CallContext context, CmisService service, String repositoryId, HttpServletRequest request, HttpServletResponse response) throws Exception {
            BigInteger skipCount;
            BigInteger maxItems;
            Boolean includeAllowableActions;
            String filter;
            String typeId;
            RelationshipDirection relationshipDirection;
            Boolean includeSubRelationshipTypes;
            assert (context != null);
            assert (service != null);
            assert (repositoryId != null);
            assert (request != null);
            assert (response != null);
            String objectId = this.getStringParameter(request, "id");
            ObjectList relationships = service.getObjectRelationships(repositoryId, objectId, includeSubRelationshipTypes = this.getBooleanParameter(request, "includeSubRelationshipTypes"), relationshipDirection = this.getEnumParameter(request, "relationshipDirection", RelationshipDirection.class), typeId = this.getStringParameter(request, "typeId"), filter = this.getStringParameter(request, "filter"), includeAllowableActions = this.getBooleanParameter(request, "includeAllowableActions"), maxItems = this.getBigIntegerParameter(request, "maxItems"), skipCount = this.getBigIntegerParameter(request, "skipCount"), null);
            if (relationships == null) {
                throw new CmisRuntimeException("Relationships are null!");
            }
            ObjectInfo objectInfo = service.getObjectInfo(repositoryId, objectId);
            if (objectInfo == null) {
                throw new CmisRuntimeException("Object Info is missing!");
            }
            response.setStatus(200);
            response.setContentType("application/atom+xml;type=feed");
            AtomFeed feed = new AtomFeed();
            feed.startDocument((OutputStream)response.getOutputStream(), this.getNamespaces(service));
            feed.startFeed(true);
            feed.writeFeedElements(objectInfo.getId(), objectInfo.getAtomId(), objectInfo.getCreatedBy(), objectInfo.getName(), objectInfo.getLastModificationDate(), null, relationships.getNumItems());
            UrlBuilder baseUrl = this.compileBaseUrl(request, repositoryId);
            feed.writeServiceLink(baseUrl.toString(), repositoryId);
            UrlBuilder selfLink = this.compileUrlBuilder(baseUrl, "relationships", objectInfo.getId());
            selfLink.addParameter("includeSubRelationshipTypes", (Object)includeSubRelationshipTypes);
            selfLink.addParameter("relationshipDirection", (Object)relationshipDirection);
            selfLink.addParameter("typeId", (Object)typeId);
            selfLink.addParameter("filter", (Object)filter);
            selfLink.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            selfLink.addParameter("maxItems", (Object)maxItems);
            selfLink.addParameter("skipCount", (Object)skipCount);
            feed.writeSelfLink(selfLink.toString(), null);
            UrlBuilder pagingUrl = new UrlBuilder(this.compileUrlBuilder(baseUrl, "relationships", objectInfo.getId()));
            pagingUrl.addParameter("includeSubRelationshipTypes", (Object)includeSubRelationshipTypes);
            pagingUrl.addParameter("relationshipDirection", (Object)relationshipDirection);
            pagingUrl.addParameter("typeId", (Object)typeId);
            pagingUrl.addParameter("filter", (Object)filter);
            pagingUrl.addParameter("includeAllowableActions", (Object)includeAllowableActions);
            feed.writePagingLinks(pagingUrl, maxItems, skipCount, relationships.getNumItems(), relationships.hasMoreItems(), PAGE_SIZE);
            AtomEntry entry = new AtomEntry(feed.getWriter());
            for (ObjectData object : relationships.getObjects()) {
                if (object == null) continue;
                this.writeObjectEntry(service, entry, object, null, repositoryId, null, null, baseUrl, false, context.getCmisVersion());
            }
            feed.writeExtensions((ExtensionsData)relationships);
            feed.endFeed();
            feed.endDocument();
        }
    }
}

