/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.ai.translate;

import com.amazonaws.services.translate.model.TranslateTextResult;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.nuxeo.ai.listeners.DocumentTranscribed;
import org.nuxeo.ai.metadata.Caption;
import org.nuxeo.ai.services.CaptionService;
import org.nuxeo.ai.transcribe.AudioTranscription;
import org.nuxeo.ai.translate.TranslateService;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;

public class ExtendedDocumentTranscribed
extends DocumentTranscribed {
    public static final String CLOSED_CAPTION_AI_TRANSLATION_LANGUAGES = "closed.caption.ai.translation.languages";
    private static final Logger log = LogManager.getLogger(ExtendedDocumentTranscribed.class);

    protected void handleEvent(Event event) {
        AudioTranscription at;
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.hasFacet("Captionable") || !doc.hasFacet("Enrichable")) {
            return;
        }
        if (!"aws.transcribe".equals(docCtx.getProperty("comment"))) {
            return;
        }
        List enrichments = (List)doc.getProperty("enrichment", "items");
        List raws = enrichments.stream().filter(en -> "aws.transcribe".equals(en.getOrDefault("model", "none"))).map(en -> (Blob)en.get("raw")).collect(Collectors.toList());
        if (raws.isEmpty()) {
            log.debug("Could not find RAW transcription for document id = " + doc.getId());
            return;
        }
        Blob json = (Blob)raws.get(0);
        if (json == null) {
            return;
        }
        try {
            at = (AudioTranscription)OBJECT_MAPPER.readValue(json.getString(), AudioTranscription.class);
        }
        catch (IOException e) {
            log.error((Object)e);
            return;
        }
        String srcLang = at.getResults().getLanguageCode();
        if (srcLang.length() > 2) {
            srcLang = srcLang.substring(0, 2);
        }
        List elements = at.getResults().getItems().stream().map(item -> {
            float st = 0.0f;
            float et = 0.0f;
            AudioTranscription.Type type = item.getType();
            if (AudioTranscription.Type.PRONUNCIATION.equals((Object)type)) {
                st = Float.parseFloat(item.getStartTime());
                et = Float.parseFloat(item.getEndTime());
            }
            String content = item.getContent();
            return new DocumentTranscribed.Element((long)(st * 1000.0f), (long)(et * 1000.0f), type, content);
        }).collect(Collectors.toList());
        List captions = this.buildCaptions(elements);
        List captionsText = captions.stream().map(caption -> (String)caption.getLines().get(0)).collect(Collectors.toList());
        TranslateService translateService = (TranslateService)Framework.getService(TranslateService.class);
        CaptionService cs = (CaptionService)Framework.getService(CaptionService.class);
        List<String> languages = Arrays.asList(Framework.getProperty((String)CLOSED_CAPTION_AI_TRANSLATION_LANGUAGES, (String)"").split(","));
        ArrayList allCaptions = new ArrayList();
        HashMap<String, Object> original = new HashMap<String, Object>();
        original.put("lang", srcLang);
        original.put("vtt", (Serializable)cs.write(captions));
        allCaptions.add(original);
        for (String destLang : languages) {
            if (destLang.equals(srcLang)) continue;
            TranslateTextResult result = translateService.translateText(String.join((CharSequence)"\n", captionsText), srcLang, destLang);
            String text = result.getTranslatedText();
            List<String> lines = List.of(text.split("\n"));
            List translatedCaptions = IntStream.range(0, lines.size()).mapToObj(i -> {
                Caption srcCaption = (Caption)captions.get(i);
                return new Caption(srcCaption.getStart(), srcCaption.getEnd(), List.of((String)lines.get(i)));
            }).collect(Collectors.toList());
            Blob translatedCaptionsFile = cs.write(translatedCaptions);
            HashMap<String, Object> translation = new HashMap<String, Object>();
            translation.put("lang", destLang);
            translation.put("vtt", (Serializable)translatedCaptionsFile);
            allCaptions.add(translation);
        }
        doc.setPropertyValue("cap:captions", (Serializable)allCaptions);
        doc.getCoreSession().saveDocument(doc);
    }
}

