/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.ai.pipes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ai.pipes.events.DocEventToStream;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.sdk.objects.PropertyType;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.platform.picture.api.adapters.MultiviewPicture;
import org.nuxeo.ecm.platform.video.VideoDocument;

public class MediaDocEvent2Stream
extends DocEventToStream {
    public MediaDocEvent2Stream(List<PropertyType> blobProperties, List<String> textProperties, List<String> customProperties) {
        super(blobProperties, textProperties, customProperties);
    }

    public Collection<BlobTextFromDocument> docSerialize(DocumentModel doc) {
        ArrayList<BlobTextFromDocument> items = new ArrayList<BlobTextFromDocument>();
        this.blobProperties.forEach(property -> {
            Blob blob = null;
            if ("video".equals(property.getType())) {
                VideoDocument videoDocument = (VideoDocument)doc.getAdapter(VideoDocument.class, true);
                blob = videoDocument.getTranscodedVideo(property.getName()).getBlob();
            } else if ("img".equals(property.getType())) {
                MultiviewPicture multiviewPicture = (MultiviewPicture)doc.getAdapter(MultiviewPicture.class, true);
                blob = multiviewPicture.getView(property.getName()).getBlob();
            }
            if (blob instanceof ManagedBlob) {
                BlobTextFromDocument blobTextFromDoc = this.getBlobText(doc);
                blobTextFromDoc.addBlob(property.getName(), property.getType(), (ManagedBlob)blob);
                items.add(blobTextFromDoc);
            }
        });
        return items;
    }
}

