/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.ai.enricher;

import com.amazonaws.services.transcribe.model.ConflictException;
import com.amazonaws.services.transcribe.model.DeleteTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.GetTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.Media;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobRequest;
import com.amazonaws.services.transcribe.model.StartTranscriptionJobResult;
import com.amazonaws.services.transcribe.model.TranscriptionJob;
import com.amazonaws.services.transcribe.model.TranscriptionJobStatus;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.nuxeo.ai.enrichment.EnrichmentDescriptor;
import org.nuxeo.ai.enrichment.EnrichmentMetadata;
import org.nuxeo.ai.enrichment.EnrichmentUtils;
import org.nuxeo.ai.enrichment.async.TranscribeEnrichmentProvider;
import org.nuxeo.ai.metadata.LabelSuggestion;
import org.nuxeo.ai.metrics.AWSMetrics;
import org.nuxeo.ai.pipes.types.BlobTextFromDocument;
import org.nuxeo.ai.transcribe.AudioTranscription;
import org.nuxeo.ai.transcribe.TranscribeService;
import org.nuxeo.ai.transcribe.TranscribeServiceImpl;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

public class TranscribeEnrichmentProviderExt
extends TranscribeEnrichmentProvider {
    public static final String PROVIDER_NAME = "aws.transcribeExt";
    private static final long TIMEOUT = 0x6DDD00L;
    private static final long WAIT_TIME = 5000L;
    private static final Logger log = LogManager.getLogger(TranscribeEnrichmentProvider.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    protected String[] languages;

    public void init(EnrichmentDescriptor descriptor) {
        super.init(descriptor);
        this.languages = descriptor.options.getOrDefault("languages", "").split(",");
    }

    public Collection<EnrichmentMetadata> enrich(BlobTextFromDocument blobTextFromDocument) {
        StartTranscriptionJobResult result;
        String docId = blobTextFromDocument.getId();
        Optional blobOptional = blobTextFromDocument.getBlobs().values().stream().findFirst();
        if (blobOptional.isEmpty()) {
            throw new NuxeoException("No Audio File to transcribe; doc id = " + blobTextFromDocument.getId());
        }
        Blob blob = (Blob)blobOptional.get();
        TranscribeService ts = (TranscribeService)Framework.getService(TranscribeService.class);
        URI blobURI = TranscribeServiceImpl.getBlobURI((Blob)blob, (boolean)false);
        Media media = new Media().withMediaFileUri(blobURI.toString());
        StartTranscriptionJobRequest request = new StartTranscriptionJobRequest().withIdentifyLanguage(Boolean.valueOf(true)).withMedia(media).withTranscriptionJobName(ts.getJobName(blob, "automatic"));
        if (StringUtils.isNoneBlank((CharSequence[])this.languages)) {
            request = request.withLanguageOptions(this.languages);
        }
        try {
            result = ts.getClient().startTranscriptionJob(request);
            ((AWSMetrics)Framework.getService(AWSMetrics.class)).getTranscribeGlobalCalls().inc();
        }
        catch (ConflictException var10) {
            String jobName = ts.getJobName(blob, "automatic");
            log.error("Job already exist {}; Deleting it", (Object)jobName);
            DeleteTranscriptionJobRequest deleteReq = (DeleteTranscriptionJobRequest)new DeleteTranscriptionJobRequest().withTranscriptionJobName(jobName).withSdkClientExecutionTimeout(5000);
            ts.getClient().deleteTranscriptionJob(deleteReq);
            result = ts.getClient().startTranscriptionJob(request);
        }
        TranscriptionJob job = result.getTranscriptionJob();
        job = this.awaitJob(docId, ts, job);
        if (TranscriptionJobStatus.FAILED.name().equals(job.getTranscriptionJobStatus())) {
            throw new NuxeoException("Transcribe job failed with reason: " + job.getFailureReason() + "; Job: " + job.getTranscriptionJobName() + " Document Id: " + docId);
        }
        String json = this.getResponse(docId, job);
        AudioTranscription transcription = this.getAudioTranscription(docId, json);
        List labels = ts.asLabels(transcription);
        List<LabelSuggestion> labelSuggestions = Collections.singletonList(new LabelSuggestion("UNSET_aws.transcribeExt", labels));
        String rawKey = EnrichmentUtils.saveRawBlob((Blob)Blobs.createJSONBlob((String)json), (String)"default");
        EnrichmentMetadata metadata = (EnrichmentMetadata)new EnrichmentMetadata.Builder("/tagging/transcribe", PROVIDER_NAME, blobTextFromDocument).withLabels(labelSuggestions).withRawKey(rawKey).build();
        return Collections.singletonList(metadata);
    }

    private AudioTranscription getAudioTranscription(String docId, String json) {
        AudioTranscription transcription;
        try {
            transcription = (AudioTranscription)OBJECT_MAPPER.readValue(json, AudioTranscription.class);
        }
        catch (IOException e) {
            log.error("Could not process JSON response {}", (Object)json, (Object)e);
            throw new NuxeoException("Could not read `AudioTranscription` for Document Id: " + docId);
        }
        return transcription;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String getResponse(String docId, TranscriptionJob job) {
        String transcriptUri = job.getTranscript().getTranscriptFileUri();
        HttpGet req = new HttpGet(transcriptUri);
        try (CloseableHttpClient httpClient = HttpClients.createDefault();){
            String string;
            block14: {
                CloseableHttpResponse resp = httpClient.execute((HttpUriRequest)req);
                try {
                    HttpEntity entity = resp.getEntity();
                    string = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
                    if (resp == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resp != null) {
                        try {
                            resp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resp.close();
            }
            return string;
        }
        catch (IOException e) {
            log.error((Object)e);
            throw new NuxeoException("Could not retrieve result for Job " + job.getTranscriptionJobName() + " Document Id: " + docId);
        }
    }

    @NotNull
    private TranscriptionJob awaitJob(String docId, TranscribeService ts, TranscriptionJob job) {
        long timeSpent = 0L;
        String jobName = job.getTranscriptionJobName();
        GetTranscriptionJobRequest jobRequest = new GetTranscriptionJobRequest().withTranscriptionJobName(jobName);
        while (TranscriptionJobStatus.IN_PROGRESS.name().equals(job.getTranscriptionJobStatus())) {
            GetTranscriptionJobResult jobResult = ts.getClient().getTranscriptionJob(jobRequest);
            job = jobResult.getTranscriptionJob();
            if (timeSpent > 0x6DDD00L) {
                throw new NuxeoException("Work reached timeout; Job name: " + jobName + " Document Id: " + docId);
            }
            try {
                Thread.sleep(5000L);
                timeSpent += 5000L;
            }
            catch (InterruptedException e) {
                log.error((Object)e);
                throw new NuxeoException("Transcribe was interrupted; could not get results for Job: " + jobName + " Document Id: " + docId, (Throwable)e);
            }
        }
        return job;
    }
}

