/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.appian.operations;

import java.io.Serializable;
import java.util.Date;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.LinkAppianRecord", category="Document", label="Appian Record Link", description="Link a document to an Appian record.")
public class LinkAppianRecord {
    public static final String ID = "Document.LinkAppianRecord";
    @Context
    protected CoreSession session;
    @Param(name="state", required=false)
    protected String state;
    @Param(name="processes", required=false)
    protected StringList processes;
    @Param(name="links", required=false)
    protected StringList links;
    @Param(name="save", required=false)
    protected boolean save;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) {
        if (!input.hasFacet("Appian")) {
            input.addFacet("Appian");
        }
        if (this.state != null) {
            input.setPropertyValue("appian:state", (Serializable)((Object)this.state));
        }
        if (this.processes != null) {
            input.setPropertyValue("appian:processes", (Serializable)this.processes);
        }
        if (this.links != null) {
            input.setPropertyValue("appian:links", (Serializable)this.links);
        }
        input.setPropertyValue("appian:synchronized", (Serializable)new Date());
        input = this.session.saveDocument(input);
        if (this.save) {
            this.session.save();
        }
        return input;
    }
}

