/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.platform.appian.operations;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.platform.appian.model.AppianResponse;
import org.nuxeo.runtime.api.Framework;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Operation(id="Document.StartAppianProcess", category="Document", label="Start Appian Process", description="Start a named Appian process with the input document.")
public class StartAppianProcess {
    protected static final Logger LOG = LoggerFactory.getLogger(StartAppianProcess.class);
    public static final String ID = "Document.StartAppianProcess";
    private Client client;
    @Context
    protected CoreSession session;
    @Context
    protected AutomationService automation;
    @Context
    protected OperationContext ctx;
    @Param(name="process", required=true)
    protected String process;
    @Param(name="reviewers", required=false)
    protected StringList reviewers;

    protected Client getClient() {
        if (this.client == null) {
            DefaultClientConfig cc = new DefaultClientConfig();
            cc.getProperties().put("com.sun.jersey.client.property.followRedirects", true);
            this.client = Client.create((ClientConfig)cc);
            String user = Framework.getProperty((String)"appian.username");
            String pass = Framework.getProperty((String)"appian.password");
            this.client.addFilter((ClientFilter)new HTTPBasicAuthFilter(user, pass));
        }
        return this.client;
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) {
        HashMap<String, Object> params;
        if (StringUtils.isBlank((CharSequence)this.process)) {
            throw new NuxeoException("No process specified");
        }
        DocumentModel processInfo = this.session.getDocument((DocumentRef)new IdRef(this.process));
        if (this.invokeEndpoint(input, processInfo, params = new HashMap<String, Object>())) {
            params.put("state", "Started");
            params.put("save", true);
            try {
                input = (DocumentModel)this.automation.run(this.ctx, "Document.LinkAppianRecord", params);
            }
            catch (OperationException e) {
                throw new NuxeoException((Throwable)e);
            }
        }
        return input;
    }

    private boolean invokeEndpoint(DocumentModel input, DocumentModel process, Map<String, Object> params) {
        boolean success;
        block21: {
            HashMap<String, List<String>> request = new HashMap<String, List<String>>();
            request.put("documentIds", Collections.singletonList(input.getId()));
            if (this.reviewers != null && !this.reviewers.isEmpty()) {
                List reviewerList = this.reviewers.stream().collect(Collectors.toList());
                request.put("reviewers", reviewerList);
            } else {
                request.put("reviewers", null);
            }
            String base = Framework.getProperty((String)"appian.base.url", (String)"https://appian");
            Serializable path = process.getPropertyValue("appianendpoint:path");
            WebResource resource = this.getClient().resource(base + path);
            Property query = process.getPropertyObject("appianendpoint", "queryParameters");
            if (query != null) {
                for (int i = 0; i < query.size(); ++i) {
                    Property p = query.get(i);
                    resource.queryParam((String)((Object)p.get("key").getValue()), (String)((Object)p.get("value").getValue()));
                }
            }
            WebResource.Builder builder = resource.accept(new String[]{"*/*"});
            Property headers = process.getPropertyObject("appianendpoint", "headers");
            if (headers != null) {
                for (int i = 0; i < headers.size(); ++i) {
                    Property p = headers.get(i);
                    builder.header((String)((Object)p.get("key").getValue()), (Object)p.get("value").getValue());
                }
            }
            success = false;
            try {
                ObjectMapper mapper = new ObjectMapper();
                String body = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(request);
                builder.type("application/json");
                ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)body);
                if (response.getStatus() < 200 || response.getStatus() >= 400) {
                    LOG.warn("Unable to reach Appian API: {} {}@{}", new Object[]{response.getStatusInfo(), Framework.getProperty((String)"appian.username"), base + path});
                    break block21;
                }
                success = true;
                AppianResponse result = null;
                try (InputStream in = response.getEntityInputStream();){
                    result = (AppianResponse)mapper.readerFor(AppianResponse.class).readValue(in);
                }
                String uuid = (String)result.getProcessInstance().get("uuid");
                params.put("processes", Collections.singletonList(uuid));
                LOG.warn("Started process with ID: {} ({})", (Object)uuid, (Object)result);
            }
            catch (Exception ex) {
                LOG.warn("Error connecting to Appian API", (Throwable)ex);
            }
        }
        return success;
    }
}

