/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.automation.extended.audit;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.ExtendedInfo;
import org.nuxeo.ecm.platform.audit.api.LogEntry;

@Operation(id="Audit.LogEventExtended", category="Services", label="LABS - Extended Log Event In Audit", description="Log events into audit")
public class ExtendedAuditLog {
    public static final String ID = "Audit.LogEventExtended";
    @Context
    protected AuditLogger logger;
    @Context
    protected OperationContext ctx;
    @Param(name="user", required=false)
    protected String user;
    @Param(name="event", widget="AuditEvent")
    protected String event;
    @Param(name="category", required=false, values={"Automation"})
    protected String category = "Automation";
    @Param(name="eventDate", required=false)
    protected Calendar eventDate = Calendar.getInstance();
    @Param(name="properties", required=false)
    protected Properties properties = new Properties();
    @Param(name="comment", required=false, widget="TextArea")
    protected String comment;

    @OperationMethod
    public void run() {
        LogEntry entry = this.newEntry(null);
        this.logger.addLogEntries(Collections.singletonList(entry));
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        LogEntry entry = this.newEntry(doc);
        this.logger.addLogEntries(Collections.singletonList(entry));
        return doc;
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
        for (DocumentModel doc : docs) {
            entries.add(this.newEntry(doc));
        }
        this.logger.addLogEntries(entries);
        return docs;
    }

    protected LogEntry newEntry(DocumentModel doc) {
        LogEntry entry = this.logger.newLogEntry();
        entry.setEventId(this.event);
        entry.setEventDate(this.eventDate.getTime());
        entry.setCategory(this.category);
        if (doc != null) {
            entry.setDocUUID(doc.getId());
            entry.setDocPath(doc.getPathAsString());
            entry.setDocType(doc.getType());
            entry.setRepositoryId(doc.getRepositoryName());
            entry.setDocLifeCycle(doc.getCurrentLifeCycleState());
        }
        if (this.comment != null) {
            entry.setComment(this.comment);
        }
        if (this.user != null) {
            entry.setPrincipalName(this.user);
        } else {
            entry.setPrincipalName(this.ctx.getPrincipal().getActingUser());
        }
        HashMap<String, ExtendedInfo> extendedInfoMap = new HashMap<String, ExtendedInfo>();
        for (Map.Entry property : this.properties.entrySet()) {
            extendedInfoMap.put((String)property.getKey(), this.logger.newExtendedInfo(this.convertValue((String)property.getValue())));
        }
        entry.setExtendedInfos(extendedInfoMap);
        return entry;
    }

    public Serializable convertValue(String str) {
        try {
            long number = Long.parseLong(str);
            return Long.valueOf(number);
        }
        catch (NumberFormatException number) {
            try {
                double number2 = Double.parseDouble(str);
                return Double.valueOf(number2);
            }
            catch (NumberFormatException numberFormatException) {
                return str;
            }
        }
    }
}

