/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.aws.bedrock.search.os;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.search.Query;
import org.opensearch.common.io.stream.StreamOutput;
import org.opensearch.common.xcontent.ToXContent;
import org.opensearch.common.xcontent.XContentBuilder;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryShardContext;

public class KnnQueryBuilder
extends AbstractQueryBuilder<KnnQueryBuilder> {
    public static final String NAME = "knn";
    public String field;
    public double[] vector;

    public KnnQueryBuilder(String field, double[] vector) {
        this.field = field;
        this.vector = vector;
    }

    protected void doWriteTo(StreamOutput out) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startObject(this.field);
        builder.startArray("vector");
        for (double d : this.vector) {
            builder.value(d);
        }
        builder.endArray();
        builder.field("k", 10);
        builder.endObject();
        builder.endObject();
    }

    protected Query doToQuery(QueryShardContext context) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected boolean doEquals(KnnQueryBuilder other) {
        return this.field.equals(other.field) && Objects.deepEquals(this.vector, other.vector);
    }

    protected int doHashCode() {
        return Objects.hash(super.hashCode(), this.field, Arrays.hashCode(this.vector));
    }

    public String getWriteableName() {
        return NAME;
    }
}

