/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.aws.bedrock.search.hint;

import java.util.Arrays;
import java.util.Base64;
import org.nuxeo.ecm.core.query.sql.model.EsHint;
import org.nuxeo.elasticsearch.api.ESHintQueryBuilder;
import org.nuxeo.labs.aws.bedrock.search.os.KnnQueryBuilder;
import org.opensearch.common.lucene.search.function.FunctionScoreQuery;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilder;
import org.opensearch.index.query.functionscore.ScoreFunctionBuilders;
import org.opensearch.index.query.functionscore.ScriptScoreFunctionBuilder;
import org.opensearch.script.Script;

public class KnnESHintQueryBuilder
implements ESHintQueryBuilder {
    public QueryBuilder make(EsHint hint, String fieldName, Object value) {
        String vectorString = new String(Base64.getDecoder().decode((String)value));
        double[] vector = Arrays.stream(vectorString.split(",")).mapToDouble(Double::parseDouble).toArray();
        KnnQueryBuilder knnQueryBuilder = new KnnQueryBuilder(fieldName, vector);
        ScriptScoreFunctionBuilder scriptFunction = ScoreFunctionBuilders.scriptFunction((Script)new Script("_score * 10"));
        FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)knnQueryBuilder, (ScoreFunctionBuilder)scriptFunction);
        functionScoreQueryBuilder.boost(1.0f);
        functionScoreQueryBuilder.maxBoost(10.0f);
        functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.SUM);
        return functionScoreQueryBuilder;
    }
}

