/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.labs.aws.bedrock.service;

import java.io.Serializable;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.labs.aws.bedrock.service.AWSBedrockService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClient;
import software.amazon.awssdk.services.bedrockruntime.BedrockRuntimeClientBuilder;
import software.amazon.awssdk.services.bedrockruntime.model.InvokeModelRequest;

public class AWSBedrockServiceImpl
extends DefaultComponent
implements AWSBedrockService {
    public static final String BEDROCK_CACHE = "bedrock_cache";

    @Override
    public String invoke(String modelName, String jsonPayload) {
        return this.invoke(modelName, jsonPayload, false);
    }

    @Override
    public String invoke(String modelName, String jsonPayload, boolean useCache) {
        String cacheKey;
        CacheService cacheService;
        Cache cache;
        if (useCache && (cache = (cacheService = (CacheService)Framework.getService(CacheService.class)).getCache(BEDROCK_CACHE)).hasEntry(cacheKey = AWSBedrockServiceImpl.getCacheKey(modelName, jsonPayload))) {
            return (String)((Object)cache.get(cacheKey));
        }
        String region = Framework.getProperty((String)"nuxeo.aws.bedrock.region");
        try (BedrockRuntimeClient client = (BedrockRuntimeClient)((BedrockRuntimeClientBuilder)((BedrockRuntimeClientBuilder)BedrockRuntimeClient.builder().region(region != null ? Region.of((String)region) : null)).credentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create())).build();){
            InvokeModelRequest request = (InvokeModelRequest)InvokeModelRequest.builder().body(SdkBytes.fromUtf8String((String)jsonPayload)).modelId(modelName).contentType("application/json").accept("application/json").build();
            String response = client.invokeModel(request).body().asUtf8String();
            if (useCache) {
                CacheService cacheService2 = (CacheService)Framework.getService(CacheService.class);
                Cache cache2 = cacheService2.getCache(BEDROCK_CACHE);
                cache2.put(AWSBedrockServiceImpl.getCacheKey(modelName, jsonPayload), (Serializable)((Object)response));
            }
            String string = response;
            return string;
        }
    }

    public static String getCacheKey(String modelName, String jsonPayload) {
        return modelName + jsonPayload;
    }
}

