/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.backgroundworkinfo.bulk;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import nuxeo.backgroundworkinfo.BgActivitiesOverview;
import nuxeo.backgroundworkinfo.BgActivitiesOverviewBasic;
import nuxeo.backgroundworkinfo.BgActivityOverview;
import nuxeo.backgroundworkinfo.api.BgActivitiesInfo;
import org.nuxeo.ecm.core.bulk.BulkCodecs;
import org.nuxeo.ecm.core.bulk.BulkService;
import org.nuxeo.ecm.core.bulk.BulkServiceImpl;
import org.nuxeo.ecm.core.bulk.message.BulkStatus;
import org.nuxeo.lib.stream.codec.Codec;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.kv.KeyValueStoreProvider;

public class BgActivitiesInfoBulk
implements BgActivitiesInfo {
    public final String TYPE = "BAF";

    @Override
    public BgActivitiesOverviewBasic fetchOverviewBasic() {
        BgActivitiesOverview overview = this.fetchOverview();
        BgActivitiesOverviewBasic overviewBasic = new BgActivitiesOverviewBasic();
        overview.forEach(oneActivity -> {
            overviewBasic.running += oneActivity.running;
            overviewBasic.scheduled += oneActivity.scheduled;
            overviewBasic.completed += oneActivity.completed;
            overviewBasic.aborted += oneActivity.aborted;
        });
        return overviewBasic;
    }

    @Override
    public BgActivitiesOverview fetchOverview() {
        BulkServiceImpl bulkServiceImpl = (BulkServiceImpl)Framework.getService(BulkService.class);
        KeyValueStoreProvider kv = (KeyValueStoreProvider)bulkServiceImpl.getKvStore();
        List statuses = kv.keyStream("status:").map(arg_0 -> ((KeyValueStoreProvider)kv).get(arg_0)).map(arg_0 -> ((Codec)BulkCodecs.getStatusCodec()).decode(arg_0)).filter(status -> status.getState() == BulkStatus.State.RUNNING || status.getState() == BulkStatus.State.SCROLLING_RUNNING || status.getState() == BulkStatus.State.SCHEDULED || status.getState() == BulkStatus.State.COMPLETED || status.getState() == BulkStatus.State.ABORTED).collect(Collectors.toList());
        HashMap<String, BgActivityOverview> overviewMap = new HashMap<String, BgActivityOverview>();
        for (BulkStatus oneStatus : statuses) {
            String actionName = oneStatus.getAction();
            BgActivityOverview overviewAction = (BgActivityOverview)overviewMap.get(actionName);
            if (overviewAction == null) {
                overviewAction = new BgActivityOverview();
                overviewAction.type = "BAF";
                overviewAction.name = actionName;
            }
            switch (oneStatus.getState()) {
                case RUNNING: 
                case SCROLLING_RUNNING: {
                    ++overviewAction.running;
                    break;
                }
                case SCHEDULED: {
                    ++overviewAction.scheduled;
                    break;
                }
                case COMPLETED: {
                    ++overviewAction.completed;
                    break;
                }
                case ABORTED: {
                    ++overviewAction.aborted;
                    break;
                }
            }
            overviewMap.put(actionName, overviewAction);
        }
        BgActivitiesOverview overview = new BgActivitiesOverview();
        overviewMap.forEach((action, actionOverview) -> overview.add(actionOverview));
        return overview;
    }
}

