/*
 * Decompiled with CFR 0.152.
 */
package nuxeo.backgroundworkinfo.operations;

import nuxeo.backgroundworkinfo.BgActivitiesOverview;
import nuxeo.backgroundworkinfo.BgActivitiesOverviewBasic;
import nuxeo.backgroundworkinfo.InfoFetcher;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;

@Operation(id="BackgroundWork.Overview", category="Services", label="Background Work: Overview", description="Return a SON object as string, quick infos about background activities. Numbers only. If infoType is Overview, BackgroundWorkOverview is a JSON array (as string) of basic info with the name of the activity)")
public class BackgroundWorkOverviewOp {
    public static final String ID = "BackgroundWork.Overview";
    @Context
    protected OperationContext ctx;
    @Param(name="infoType", description="Type of info to return", values={"Basic", "Overview"})
    protected String infoType = "Basic";

    @OperationMethod
    public String run() throws JSONException {
        String result = "{}";
        if (StringUtils.isBlank((CharSequence)this.infoType)) {
            this.infoType = "Basic";
        }
        InfoFetcher fetcher = InfoFetcher.getInstance();
        switch (this.infoType) {
            case "Overview": {
                BgActivitiesOverview overview = fetcher.fetchOverview();
                result = overview.toJson().toString();
                break;
            }
            default: {
                BgActivitiesOverviewBasic overviewBasic = fetcher.fetchOverviewBasic();
                result = overviewBasic.toJson().toString();
            }
        }
        return result;
    }
}

