/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.base64;

import java.io.IOException;
import java.util.Base64;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;

@Operation(id="Blob.ConvertToBase64", category="Conversion", label="Convert to base64", description="Convert a blob to base 64")
public class ConvertToBase64 {
    public static final String ID = "Blob.ConvertToBase64";
    @Context
    protected CoreSession session;

    @OperationMethod
    public String run(Blob blob) {
        if (blob == null) {
            return null;
        }
        try {
            return Base64.getEncoder().encodeToString(blob.getByteArray());
        }
        catch (IOException ioe) {
            throw new NuxeoException("Cannot convert file: " + blob.getFilename() + " to base64");
        }
    }
}

